/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.annotations;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExampleData {
    public static Pattern CTOR_PATTERN = Pattern.compile("(?<funcname>[^)]+)\\((?<args>.+)\\)");
    public static Pattern VALS_PATTERN = Pattern.compile("\\[(?<values>-?\\d+([,-. ]+-?\\d+)*)]");
    private Pattern COMMA_VALS = Pattern.compile("\\[(?<vals>-?\\d+(,-?\\d+)*)]");
    private Pattern RANGE_VALS = Pattern.compile("\\[(?<from>-?\\d+)\\.\\.(?<to>-?\\d+)( +(?<step>-?\\d+))?]");
    public String[] parts;

    public ExampleData(String[] stringArray) {
        this.parts = stringArray;
    }

    public static void validateExamples(List<List<String>> list) {
        for (List<String> list2 : list) {
            for (String string : list2) {
                if (CTOR_PATTERN.matcher(string).matches() || VALS_PATTERN.matcher(string).matches()) continue;
                if (!string.startsWith("[")) {
                    return;
                }
                throw new RuntimeException("Unable to match a valid pattern for example fragment '" + string + "'). See javadoc for the Example annotation for details.");
            }
        }
    }

    public long[] getLongInputs() {
        long[] lArray = new long[]{};
        for (String string : this.parts) {
            int n;
            if (!VALS_PATTERN.matcher(string).matches()) continue;
            String[] stringArray = string.split(";");
            long[][] lArrayArray = new long[stringArray.length][];
            int n2 = 0;
            for (n = 0; n < lArrayArray.length; ++n) {
                String string2 = stringArray[n];
                lArrayArray[n] = this.parseRange(string2);
                n2 += lArrayArray[n].length;
            }
            lArray = new long[n2];
            n = 0;
            for (int i = 0; i < lArrayArray.length; ++i) {
                System.arraycopy(lArrayArray[i], 0, lArray, n, lArrayArray[i].length);
                n += lArrayArray[i].length;
            }
        }
        return lArray;
    }

    private long[] parseRange(String string) {
        Matcher matcher = this.COMMA_VALS.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group("vals");
            long[] lArray = Arrays.stream(string2.split(",")).mapToLong(Long::valueOf).toArray();
            return lArray;
        }
        Matcher matcher2 = this.RANGE_VALS.matcher(string);
        if (matcher2.matches()) {
            long l = Long.parseLong(matcher2.group("from"));
            long l2 = Long.parseLong(matcher2.group("to"));
            String string3 = matcher2.group("step");
            long l3 = 1L;
            if (string3 != null) {
                l3 = Long.parseLong(string3);
            }
            if (l < l2 && l3 <= 0L) {
                throw new RuntimeException("for increasing from-to of (" + l + "-" + l2 + ":, stepsize must be positive.");
            }
            if (l > l2 && l3 >= 0L) {
                throw new RuntimeException("for decreasing from-to of (" + l + "-" + l2 + ":, stepsize must be negative.");
            }
            long l4 = Math.abs(l - l2) / Math.abs(l3) + 1L;
            if (l4 > Integer.MAX_VALUE) {
                throw new RuntimeException("example size " + l4 + " is too big.");
            }
            long[] lArray = new long[(int)l4];
            long l5 = l3 > 0L ? 1L : -1L;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = l + l3 * (long)i;
            }
            return lArray;
        }
        throw new RuntimeException("Unable to parse spec pattern: '" + string + "'");
    }
}

