/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive;

import io.virtdata.shaded.oac.statistics.descriptive.StatisticalSummary;
import io.virtdata.shaded.oac.statistics.descriptive.UnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.moment.GeometricMean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Kurtosis;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Skewness;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Variance;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Max;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Min;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Percentile;
import io.virtdata.shaded.oac.statistics.descriptive.summary.Sum;
import io.virtdata.shaded.oac.statistics.descriptive.summary.SumOfSquares;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.math4.util.ResizableDoubleArray;

public class DescriptiveStatistics
implements StatisticalSummary,
Serializable {
    public static final int INFINITE_WINDOW = -1;
    private static final long serialVersionUID = 4133067267405273064L;
    private static final String SET_QUANTILE_METHOD_NAME = "setQuantile";
    private int windowSize = -1;
    private ResizableDoubleArray eDA = new ResizableDoubleArray();
    private UnivariateStatistic meanImpl = new Mean();
    private UnivariateStatistic geometricMeanImpl = new GeometricMean();
    private UnivariateStatistic kurtosisImpl = new Kurtosis();
    private UnivariateStatistic maxImpl = new Max();
    private UnivariateStatistic minImpl = new Min();
    private UnivariateStatistic percentileImpl = new Percentile();
    private UnivariateStatistic skewnessImpl = new Skewness();
    private UnivariateStatistic varianceImpl = new Variance();
    private UnivariateStatistic sumsqImpl = new SumOfSquares();
    private UnivariateStatistic sumImpl = new Sum();

    public DescriptiveStatistics() {
    }

    public DescriptiveStatistics(int n) throws MathIllegalArgumentException {
        this.setWindowSize(n);
    }

    public DescriptiveStatistics(double[] dArray) {
        if (dArray != null) {
            this.eDA = new ResizableDoubleArray(dArray);
        }
    }

    public DescriptiveStatistics(Double[] doubleArray) {
        if (doubleArray != null) {
            this.eDA = new ResizableDoubleArray(doubleArray.length);
            Double[] doubleArray2 = doubleArray;
            int n = doubleArray2.length;
            for (int i = 0; i < n; ++i) {
                double d = doubleArray2[i];
                this.eDA.addElement(d);
            }
        }
    }

    public DescriptiveStatistics(DescriptiveStatistics descriptiveStatistics) throws NullArgumentException {
        DescriptiveStatistics.copy(descriptiveStatistics, this);
    }

    public void addValue(double d) {
        if (this.windowSize != -1) {
            if (this.getN() == (long)this.windowSize) {
                this.eDA.addElementRolling(d);
            } else if (this.getN() < (long)this.windowSize) {
                this.eDA.addElement(d);
            }
        } else {
            this.eDA.addElement(d);
        }
    }

    public void removeMostRecentValue() throws MathIllegalStateException {
        try {
            this.eDA.discardMostRecentElements(1);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw new MathIllegalStateException(LocalizedFormats.NO_DATA, new Object[0]);
        }
    }

    public double replaceMostRecentValue(double d) throws MathIllegalStateException {
        return this.eDA.substituteMostRecentElement(d);
    }

    @Override
    public double getMean() {
        return this.apply(this.meanImpl);
    }

    public double getGeometricMean() {
        return this.apply(this.geometricMeanImpl);
    }

    @Override
    public double getVariance() {
        return this.apply(this.varianceImpl);
    }

    public double getPopulationVariance() {
        return this.apply(new Variance(false));
    }

    @Override
    public double getStandardDeviation() {
        double d = Double.NaN;
        if (this.getN() > 0L) {
            d = this.getN() > 1L ? FastMath.sqrt(this.getVariance()) : 0.0;
        }
        return d;
    }

    public double getQuadraticMean() {
        long l = this.getN();
        return l > 0L ? FastMath.sqrt(this.getSumsq() / (double)l) : Double.NaN;
    }

    public double getSkewness() {
        return this.apply(this.skewnessImpl);
    }

    public double getKurtosis() {
        return this.apply(this.kurtosisImpl);
    }

    @Override
    public double getMax() {
        return this.apply(this.maxImpl);
    }

    @Override
    public double getMin() {
        return this.apply(this.minImpl);
    }

    @Override
    public long getN() {
        return this.eDA.getNumElements();
    }

    @Override
    public double getSum() {
        return this.apply(this.sumImpl);
    }

    public double getSumsq() {
        return this.apply(this.sumsqImpl);
    }

    public void clear() {
        this.eDA.clear();
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int n) throws MathIllegalArgumentException {
        if (n < 1 && n != -1) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_WINDOW_SIZE, n);
        }
        this.windowSize = n;
        if (n != -1 && n < this.eDA.getNumElements()) {
            this.eDA.discardFrontElements(this.eDA.getNumElements() - n);
        }
    }

    public double[] getValues() {
        return this.eDA.getElements();
    }

    public double[] getSortedValues() {
        double[] dArray = this.getValues();
        Arrays.sort(dArray);
        return dArray;
    }

    public double getElement(int n) {
        return this.eDA.getElement(n);
    }

    public double getPercentile(double d) throws MathIllegalStateException, MathIllegalArgumentException {
        if (this.percentileImpl instanceof Percentile) {
            ((Percentile)this.percentileImpl).setQuantile(d);
        } else {
            try {
                this.percentileImpl.getClass().getMethod(SET_QUANTILE_METHOD_NAME, Double.TYPE).invoke((Object)this.percentileImpl, d);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MathIllegalStateException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_UNSUPPORTED_METHOD, this.percentileImpl.getClass().getName(), SET_QUANTILE_METHOD_NAME);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MathIllegalStateException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_CANNOT_ACCESS_METHOD, SET_QUANTILE_METHOD_NAME, this.percentileImpl.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException.getCause());
            }
        }
        return this.apply(this.percentileImpl);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\n";
        stringBuilder.append("DescriptiveStatistics:").append(string);
        stringBuilder.append("n: ").append(this.getN()).append(string);
        stringBuilder.append("min: ").append(this.getMin()).append(string);
        stringBuilder.append("max: ").append(this.getMax()).append(string);
        stringBuilder.append("mean: ").append(this.getMean()).append(string);
        stringBuilder.append("std dev: ").append(this.getStandardDeviation()).append(string);
        try {
            stringBuilder.append("median: ").append(this.getPercentile(50.0)).append(string);
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            stringBuilder.append("median: unavailable").append(string);
        }
        stringBuilder.append("skewness: ").append(this.getSkewness()).append(string);
        stringBuilder.append("kurtosis: ").append(this.getKurtosis()).append(string);
        return stringBuilder.toString();
    }

    public double apply(UnivariateStatistic univariateStatistic) {
        return this.eDA.compute(univariateStatistic);
    }

    public synchronized UnivariateStatistic getMeanImpl() {
        return this.meanImpl;
    }

    public synchronized void setMeanImpl(UnivariateStatistic univariateStatistic) {
        this.meanImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getGeometricMeanImpl() {
        return this.geometricMeanImpl;
    }

    public synchronized void setGeometricMeanImpl(UnivariateStatistic univariateStatistic) {
        this.geometricMeanImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getKurtosisImpl() {
        return this.kurtosisImpl;
    }

    public synchronized void setKurtosisImpl(UnivariateStatistic univariateStatistic) {
        this.kurtosisImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getMaxImpl() {
        return this.maxImpl;
    }

    public synchronized void setMaxImpl(UnivariateStatistic univariateStatistic) {
        this.maxImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getMinImpl() {
        return this.minImpl;
    }

    public synchronized void setMinImpl(UnivariateStatistic univariateStatistic) {
        this.minImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getPercentileImpl() {
        return this.percentileImpl;
    }

    public synchronized void setPercentileImpl(UnivariateStatistic univariateStatistic) throws MathIllegalArgumentException {
        try {
            univariateStatistic.getClass().getMethod(SET_QUANTILE_METHOD_NAME, Double.TYPE).invoke((Object)univariateStatistic, 50.0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MathIllegalArgumentException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_UNSUPPORTED_METHOD, univariateStatistic.getClass().getName(), SET_QUANTILE_METHOD_NAME);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MathIllegalArgumentException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_CANNOT_ACCESS_METHOD, SET_QUANTILE_METHOD_NAME, univariateStatistic.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException.getCause());
        }
        this.percentileImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getSkewnessImpl() {
        return this.skewnessImpl;
    }

    public synchronized void setSkewnessImpl(UnivariateStatistic univariateStatistic) {
        this.skewnessImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getVarianceImpl() {
        return this.varianceImpl;
    }

    public synchronized void setVarianceImpl(UnivariateStatistic univariateStatistic) {
        this.varianceImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getSumsqImpl() {
        return this.sumsqImpl;
    }

    public synchronized void setSumsqImpl(UnivariateStatistic univariateStatistic) {
        this.sumsqImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getSumImpl() {
        return this.sumImpl;
    }

    public synchronized void setSumImpl(UnivariateStatistic univariateStatistic) {
        this.sumImpl = univariateStatistic;
    }

    public DescriptiveStatistics copy() {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        DescriptiveStatistics.copy(this, descriptiveStatistics);
        return descriptiveStatistics;
    }

    public static void copy(DescriptiveStatistics descriptiveStatistics, DescriptiveStatistics descriptiveStatistics2) throws NullArgumentException {
        MathUtils.checkNotNull(descriptiveStatistics);
        MathUtils.checkNotNull(descriptiveStatistics2);
        descriptiveStatistics2.eDA = descriptiveStatistics.eDA.copy();
        descriptiveStatistics2.windowSize = descriptiveStatistics.windowSize;
        descriptiveStatistics2.maxImpl = descriptiveStatistics.maxImpl.copy();
        descriptiveStatistics2.meanImpl = descriptiveStatistics.meanImpl.copy();
        descriptiveStatistics2.minImpl = descriptiveStatistics.minImpl.copy();
        descriptiveStatistics2.sumImpl = descriptiveStatistics.sumImpl.copy();
        descriptiveStatistics2.varianceImpl = descriptiveStatistics.varianceImpl.copy();
        descriptiveStatistics2.sumsqImpl = descriptiveStatistics.sumsqImpl.copy();
        descriptiveStatistics2.geometricMeanImpl = descriptiveStatistics.geometricMeanImpl.copy();
        descriptiveStatistics2.kurtosisImpl = descriptiveStatistics.kurtosisImpl;
        descriptiveStatistics2.skewnessImpl = descriptiveStatistics.skewnessImpl;
        descriptiveStatistics2.percentileImpl = descriptiveStatistics.percentileImpl;
    }
}

