/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;

public class UniformContinuousDistribution
extends AbstractContinuousDistribution {
    private final double lower;
    private final double upper;

    public UniformContinuousDistribution(double d, double d2) {
        if (d >= d2) {
            throw new DistributionException("{0} > {1}", d, d2);
        }
        this.lower = d;
        this.upper = d2;
    }

    @Override
    public double density(double d) {
        if (d < this.lower || d > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upper - this.lower);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d <= this.lower) {
            return 0.0;
        }
        if (d >= this.upper) {
            return 1.0;
        }
        return (d - this.lower) / (this.upper - this.lower);
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        return d * (this.upper - this.lower) + this.lower;
    }

    @Override
    public double getMean() {
        return 0.5 * (this.lower + this.upper);
    }

    @Override
    public double getVariance() {
        double d = this.upper - this.lower;
        return d * d / 12.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public double getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new ContinuousUniformSampler(uniformRandomProvider, UniformContinuousDistribution.this.lower, UniformContinuousDistribution.this.upper);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

