/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import java.math.BigDecimal;
import org.apache.commons.math4.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math4.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math4.analysis.integration.gauss.HermiteRuleFactory;
import org.apache.commons.math4.analysis.integration.gauss.LaguerreRuleFactory;
import org.apache.commons.math4.analysis.integration.gauss.LegendreHighPrecisionRuleFactory;
import org.apache.commons.math4.analysis.integration.gauss.LegendreRuleFactory;
import org.apache.commons.math4.analysis.integration.gauss.SymmetricGaussIntegrator;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.util.Pair;

public class GaussIntegratorFactory {
    private final BaseRuleFactory<Double> legendre = new LegendreRuleFactory();
    private final BaseRuleFactory<BigDecimal> legendreHighPrecision = new LegendreHighPrecisionRuleFactory();
    private final BaseRuleFactory<Double> hermite = new HermiteRuleFactory();
    private final BaseRuleFactory<Double> laguerre = new LaguerreRuleFactory();

    public GaussIntegrator laguerre(int n) {
        return new GaussIntegrator(GaussIntegratorFactory.getRule(this.laguerre, n));
    }

    public GaussIntegrator legendre(int n) {
        return new GaussIntegrator(GaussIntegratorFactory.getRule(this.legendre, n));
    }

    public GaussIntegrator legendre(int n, double d, double d2) throws NotStrictlyPositiveException {
        return new GaussIntegrator(GaussIntegratorFactory.transform(GaussIntegratorFactory.getRule(this.legendre, n), d, d2));
    }

    public GaussIntegrator legendreHighPrecision(int n) throws NotStrictlyPositiveException {
        return new GaussIntegrator(GaussIntegratorFactory.getRule(this.legendreHighPrecision, n));
    }

    public GaussIntegrator legendreHighPrecision(int n, double d, double d2) throws NotStrictlyPositiveException {
        return new GaussIntegrator(GaussIntegratorFactory.transform(GaussIntegratorFactory.getRule(this.legendreHighPrecision, n), d, d2));
    }

    public SymmetricGaussIntegrator hermite(int n) {
        return new SymmetricGaussIntegrator(GaussIntegratorFactory.getRule(this.hermite, n));
    }

    private static Pair<double[], double[]> getRule(BaseRuleFactory<? extends Number> baseRuleFactory, int n) throws NotStrictlyPositiveException, DimensionMismatchException {
        return baseRuleFactory.getRule(n);
    }

    private static Pair<double[], double[]> transform(Pair<double[], double[]> pair, double d, double d2) {
        double[] dArray = pair.getFirst();
        double[] dArray2 = pair.getSecond();
        double d3 = (d2 - d) / 2.0;
        double d4 = d + d3;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = dArray[n] * d3 + d4;
            int n2 = n++;
            dArray2[n2] = dArray2[n2] * d3;
        }
        return new Pair<double[], double[]>(dArray, dArray2);
    }
}

