/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.polynomials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.fraction.BigFraction;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.combinatorics.BinomialCoefficient;

public class PolynomialsUtils {
    private static final List<BigFraction> CHEBYSHEV_COEFFICIENTS = new ArrayList<BigFraction>();
    private static final List<BigFraction> HERMITE_COEFFICIENTS;
    private static final List<BigFraction> LAGUERRE_COEFFICIENTS;
    private static final List<BigFraction> LEGENDRE_COEFFICIENTS;
    private static final Map<JacobiKey, List<BigFraction>> JACOBI_COEFFICIENTS;

    private PolynomialsUtils() {
    }

    public static PolynomialFunction createChebyshevPolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, CHEBYSHEV_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){
            private final BigFraction[] coeffs = new BigFraction[]{BigFraction.ZERO, BigFraction.TWO, BigFraction.ONE};

            @Override
            public BigFraction[] generate(int n) {
                return this.coeffs;
            }
        });
    }

    public static PolynomialFunction createHermitePolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, HERMITE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int n) {
                return new BigFraction[]{BigFraction.ZERO, BigFraction.TWO, new BigFraction(2 * n)};
            }
        });
    }

    public static PolynomialFunction createLaguerrePolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, LAGUERRE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int n) {
                int n2 = n + 1;
                return new BigFraction[]{new BigFraction(2 * n + 1, n2), new BigFraction(-1, n2), new BigFraction(n, n2)};
            }
        });
    }

    public static PolynomialFunction createLegendrePolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, LEGENDRE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int n) {
                int n2 = n + 1;
                return new BigFraction[]{BigFraction.ZERO, new BigFraction(n + n2, n2), new BigFraction(n, n2)};
            }
        });
    }

    public static PolynomialFunction createJacobiPolynomial(int n, final int n2, final int n3) {
        JacobiKey jacobiKey = new JacobiKey(n2, n3);
        if (!JACOBI_COEFFICIENTS.containsKey(jacobiKey)) {
            ArrayList<BigFraction> arrayList = new ArrayList<BigFraction>();
            JACOBI_COEFFICIENTS.put(jacobiKey, arrayList);
            arrayList.add(BigFraction.ONE);
            arrayList.add(new BigFraction(n2 - n3, 2));
            arrayList.add(new BigFraction(2 + n2 + n3, 2));
        }
        return PolynomialsUtils.buildPolynomial(n, JACOBI_COEFFICIENTS.get(jacobiKey), new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int n) {
                int n22 = ++n + n2 + n3;
                int n32 = n22 + n;
                int n4 = n32 - 1;
                int n5 = n32 - 2;
                int n6 = 2 * n * n22 * n5;
                return new BigFraction[]{new BigFraction(n4 * (n2 * n2 - n3 * n3), n6), new BigFraction(n4 * n32 * n5, n6), new BigFraction(2 * (n + n2 - 1) * (n + n3 - 1) * n32, n6)};
            }
        });
    }

    public static double[] shift(double[] dArray, double d) {
        int n;
        int n2;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        int[][] nArray = new int[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n <= n2; ++n) {
                nArray[n2][n] = (int)BinomialCoefficient.value(n2, n);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[0] = dArray2[0] + dArray[n2] * FastMath.pow(d, n2);
        }
        n2 = n3 - 1;
        for (n = 0; n < n2; ++n) {
            for (int i = n; i < n2; ++i) {
                int n4 = n + 1;
                dArray2[n4] = dArray2[n4] + (double)nArray[i + 1][i - n] * dArray[i + 1] * FastMath.pow(d, i - n);
            }
        }
        return dArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolynomialFunction buildPolynomial(int n, List<BigFraction> list, RecurrenceCoefficientsGenerator recurrenceCoefficientsGenerator) {
        List<BigFraction> list2 = list;
        synchronized (list2) {
            int n2 = (int)FastMath.floor(FastMath.sqrt(2 * list.size())) - 1;
            if (n > n2) {
                PolynomialsUtils.computeUpToDegree(n, n2, recurrenceCoefficientsGenerator, list);
            }
        }
        int n3 = n * (n + 1) / 2;
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = list.get(n3 + i).doubleValue();
        }
        return new PolynomialFunction(dArray);
    }

    private static void computeUpToDegree(int n, int n2, RecurrenceCoefficientsGenerator recurrenceCoefficientsGenerator, List<BigFraction> list) {
        int n3 = (n2 - 1) * n2 / 2;
        for (int i = n2; i < n; ++i) {
            int n4 = n3;
            BigFraction[] bigFractionArray = recurrenceCoefficientsGenerator.generate(i);
            BigFraction bigFraction = list.get(n3 += i);
            BigFraction bigFraction2 = list.get(n4);
            list.add(bigFraction.multiply(bigFractionArray[0]).subtract(bigFraction2.multiply(bigFractionArray[2])));
            for (int j = 1; j < i; ++j) {
                BigFraction bigFraction3 = bigFraction;
                bigFraction = list.get(n3 + j);
                bigFraction2 = list.get(n4 + j);
                list.add(bigFraction.multiply(bigFractionArray[0]).add(bigFraction3.multiply(bigFractionArray[1])).subtract(bigFraction2.multiply(bigFractionArray[2])));
            }
            BigFraction bigFraction4 = bigFraction;
            bigFraction = list.get(n3 + i);
            list.add(bigFraction.multiply(bigFractionArray[0]).add(bigFraction4.multiply(bigFractionArray[1])));
            list.add(bigFraction.multiply(bigFractionArray[1]));
        }
    }

    static {
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ZERO);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS = new ArrayList<BigFraction>();
        HERMITE_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS.add(BigFraction.ZERO);
        HERMITE_COEFFICIENTS.add(BigFraction.TWO);
        LAGUERRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.MINUS_ONE);
        LEGENDRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ZERO);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        JACOBI_COEFFICIENTS = new HashMap<JacobiKey, List<BigFraction>>();
    }

    private static interface RecurrenceCoefficientsGenerator {
        public BigFraction[] generate(int var1);
    }

    private static class JacobiKey {
        private final int v;
        private final int w;

        JacobiKey(int n, int n2) {
            this.v = n;
            this.w = n2;
        }

        public int hashCode() {
            return this.v << 16 ^ this.w;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof JacobiKey)) {
                return false;
            }
            JacobiKey jacobiKey = (JacobiKey)object;
            return this.v == jacobiKey.v && this.w == jacobiKey.w;
        }
    }
}

