/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.FastMath;

class BiDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedU;
    private RealMatrix cachedB;
    private RealMatrix cachedV;

    BiDiagonalTransformer(RealMatrix realMatrix) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        int n3 = FastMath.min(n, n2);
        this.householderVectors = realMatrix.getData();
        this.main = new double[n3];
        this.secondary = new double[n3 - 1];
        this.cachedU = null;
        this.cachedB = null;
        this.cachedV = null;
        if (n >= n2) {
            this.transformToUpperBiDiagonal();
        } else {
            this.transformToLowerBiDiagonal();
        }
    }

    public RealMatrix getU() {
        if (this.cachedU == null) {
            int n;
            int n2 = this.householderVectors.length;
            int n3 = this.householderVectors[0].length;
            int n4 = this.main.length;
            int n5 = n2 >= n3 ? 0 : 1;
            double[] dArray = n2 >= n3 ? this.main : this.secondary;
            double[][] dArray2 = new double[n2][n2];
            for (n = n2 - 1; n >= n4; --n) {
                dArray2[n][n] = 1.0;
            }
            for (n = n4 - 1; n >= n5; --n) {
                double[] dArray3 = this.householderVectors[n];
                dArray2[n][n] = 1.0;
                if (dArray3[n - n5] == 0.0) continue;
                for (int i = n; i < n2; ++i) {
                    int n6;
                    double d = 0.0;
                    for (n6 = n; n6 < n2; ++n6) {
                        d -= dArray2[n6][i] * this.householderVectors[n6][n - n5];
                    }
                    d /= dArray[n - n5] * dArray3[n - n5];
                    for (n6 = n; n6 < n2; ++n6) {
                        double[] dArray4 = dArray2[n6];
                        int n7 = i;
                        dArray4[n7] = dArray4[n7] + -d * this.householderVectors[n6][n - n5];
                    }
                }
            }
            if (n5 > 0) {
                dArray2[0][0] = 1.0;
            }
            this.cachedU = MatrixUtils.createRealMatrix(dArray2);
        }
        return this.cachedU;
    }

    public RealMatrix getB() {
        if (this.cachedB == null) {
            int n = this.householderVectors.length;
            int n2 = this.householderVectors[0].length;
            double[][] dArray = new double[n][n2];
            for (int i = 0; i < this.main.length; ++i) {
                dArray[i][i] = this.main[i];
                if (n < n2) {
                    if (i <= 0) continue;
                    dArray[i][i - 1] = this.secondary[i - 1];
                    continue;
                }
                if (i >= this.main.length - 1) continue;
                dArray[i][i + 1] = this.secondary[i];
            }
            this.cachedB = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedB;
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int n;
            int n2 = this.householderVectors.length;
            int n3 = this.householderVectors[0].length;
            int n4 = this.main.length;
            int n5 = n2 >= n3 ? 1 : 0;
            double[] dArray = n2 >= n3 ? this.secondary : this.main;
            double[][] dArray2 = new double[n3][n3];
            for (n = n3 - 1; n >= n4; --n) {
                dArray2[n][n] = 1.0;
            }
            for (n = n4 - 1; n >= n5; --n) {
                double[] dArray3 = this.householderVectors[n - n5];
                dArray2[n][n] = 1.0;
                if (dArray3[n] == 0.0) continue;
                for (int i = n; i < n3; ++i) {
                    int n6;
                    double d = 0.0;
                    for (n6 = n; n6 < n3; ++n6) {
                        d -= dArray2[n6][i] * dArray3[n6];
                    }
                    d /= dArray[n - n5] * dArray3[n];
                    for (n6 = n; n6 < n3; ++n6) {
                        double[] dArray4 = dArray2[n6];
                        int n7 = i;
                        dArray4[n7] = dArray4[n7] + -d * dArray3[n6];
                    }
                }
            }
            if (n5 > 0) {
                dArray2[0][0] = 1.0;
            }
            this.cachedV = MatrixUtils.createRealMatrix(dArray2);
        }
        return this.cachedV;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    boolean isUpperBiDiagonal() {
        return this.householderVectors.length >= this.householderVectors[0].length;
    }

    private void transformToUpperBiDiagonal() {
        int n = this.householderVectors.length;
        int n2 = this.householderVectors[0].length;
        for (int i = 0; i < n2; ++i) {
            double d;
            double d2;
            int n3;
            double d3;
            double d4 = 0.0;
            for (int j = i; j < n; ++j) {
                d3 = this.householderVectors[j][i];
                d4 += d3 * d3;
            }
            double[] dArray = this.householderVectors[i];
            this.main[i] = d3 = dArray[i] > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            if (d3 != 0.0) {
                int n4 = i;
                dArray[n4] = dArray[n4] - d3;
                for (n3 = i + 1; n3 < n2; ++n3) {
                    double[] dArray2;
                    int n5;
                    d2 = 0.0;
                    for (n5 = i; n5 < n; ++n5) {
                        dArray2 = this.householderVectors[n5];
                        d2 -= dArray2[n3] * dArray2[i];
                    }
                    d2 /= d3 * this.householderVectors[i][i];
                    for (n5 = i; n5 < n; ++n5) {
                        dArray2 = this.householderVectors[n5];
                        int n6 = n3;
                        dArray2[n6] = dArray2[n6] - d2 * dArray2[i];
                    }
                }
            }
            if (i >= n2 - 1) continue;
            d4 = 0.0;
            for (n3 = i + 1; n3 < n2; ++n3) {
                d2 = dArray[n3];
                d4 += d2 * d2;
            }
            this.secondary[i] = d = dArray[i + 1] > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            if (d == 0.0) continue;
            int n7 = i + 1;
            dArray[n7] = dArray[n7] - d;
            for (int j = i + 1; j < n; ++j) {
                int n8;
                double[] dArray3 = this.householderVectors[j];
                double d5 = 0.0;
                for (n8 = i + 1; n8 < n2; ++n8) {
                    d5 -= dArray3[n8] * dArray[n8];
                }
                d5 /= d * dArray[i + 1];
                for (n8 = i + 1; n8 < n2; ++n8) {
                    int n9 = n8;
                    dArray3[n9] = dArray3[n9] - d5 * dArray[n8];
                }
            }
        }
    }

    private void transformToLowerBiDiagonal() {
        int n = this.householderVectors.length;
        int n2 = this.householderVectors[0].length;
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            double d3;
            double[] dArray = this.householderVectors[i];
            double d4 = 0.0;
            for (int j = i; j < n2; ++j) {
                double d5 = dArray[j];
                d4 += d5 * d5;
            }
            this.main[i] = d3 = dArray[i] > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            if (d3 != 0.0) {
                int n3 = i;
                dArray[n3] = dArray[n3] - d3;
                for (int j = i + 1; j < n; ++j) {
                    int n4;
                    double[] dArray2 = this.householderVectors[j];
                    d2 = 0.0;
                    for (n4 = i; n4 < n2; ++n4) {
                        d2 -= dArray2[n4] * dArray[n4];
                    }
                    d2 /= d3 * this.householderVectors[i][i];
                    for (n4 = i; n4 < n2; ++n4) {
                        int n5 = n4;
                        dArray2[n5] = dArray2[n5] - d2 * dArray[n4];
                    }
                }
            }
            if (i >= n - 1) continue;
            double[] dArray3 = this.householderVectors[i + 1];
            d4 = 0.0;
            for (int j = i + 1; j < n; ++j) {
                d2 = this.householderVectors[j][i];
                d4 += d2 * d2;
            }
            this.secondary[i] = d = dArray3[i] > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            if (d == 0.0) continue;
            int n6 = i;
            dArray3[n6] = dArray3[n6] - d;
            for (int j = i + 1; j < n2; ++j) {
                double[] dArray4;
                int n7;
                double d6 = 0.0;
                for (n7 = i + 1; n7 < n; ++n7) {
                    dArray4 = this.householderVectors[n7];
                    d6 -= dArray4[j] * dArray4[i];
                }
                d6 /= d * dArray3[i];
                for (n7 = i + 1; n7 < n; ++n7) {
                    dArray4 = this.householderVectors[n7];
                    int n8 = j;
                    dArray4[n8] = dArray4[n8] - d6 * dArray4[i];
                }
            }
        }
    }
}

