/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.analysis.function.Sqrt;
import org.apache.commons.math4.linear.AbstractRealMatrix;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.NonSquareOperatorException;
import org.apache.commons.math4.linear.RealLinearOperator;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.MathArrays;

public class JacobiPreconditioner
extends RealLinearOperator {
    private final ArrayRealVector diag;

    public JacobiPreconditioner(double[] dArray, boolean bl) {
        this.diag = new ArrayRealVector(dArray, bl);
    }

    public static JacobiPreconditioner create(RealLinearOperator realLinearOperator) throws NonSquareOperatorException {
        int n = realLinearOperator.getColumnDimension();
        if (realLinearOperator.getRowDimension() != n) {
            throw new NonSquareOperatorException(realLinearOperator.getRowDimension(), n);
        }
        double[] dArray = new double[n];
        if (realLinearOperator instanceof AbstractRealMatrix) {
            AbstractRealMatrix abstractRealMatrix = (AbstractRealMatrix)realLinearOperator;
            for (int i = 0; i < n; ++i) {
                dArray[i] = abstractRealMatrix.getEntry(i, i);
            }
        } else {
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            for (int i = 0; i < n; ++i) {
                arrayRealVector.set(0.0);
                arrayRealVector.setEntry(i, 1.0);
                dArray[i] = realLinearOperator.operate(arrayRealVector).getEntry(i);
            }
        }
        return new JacobiPreconditioner(dArray, false);
    }

    @Override
    public int getColumnDimension() {
        return this.diag.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diag.getDimension();
    }

    @Override
    public RealVector operate(RealVector realVector) {
        return new ArrayRealVector(MathArrays.ebeDivide(realVector.toArray(), this.diag.toArray()), false);
    }

    public RealLinearOperator sqrt() {
        final ArrayRealVector arrayRealVector = this.diag.map(new Sqrt());
        return new RealLinearOperator(){

            @Override
            public RealVector operate(RealVector realVector) {
                return new ArrayRealVector(MathArrays.ebeDivide(realVector.toArray(), arrayRealVector.toArray()), false);
            }

            @Override
            public int getRowDimension() {
                return arrayRealVector.getDimension();
            }

            @Override
            public int getColumnDimension() {
                return arrayRealVector.getDimension();
            }
        };
    }
}

