/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class LongProvider
extends BaseProvider
implements RandomLongSource {
    private long booleanSource;
    private long booleanBitMask;
    private long intSource;
    private boolean cachedIntSource;

    @Override
    protected byte[] getStateInternal() {
        long[] lArray = new long[]{this.booleanSource, this.booleanBitMask, this.intSource, this.cachedIntSource ? 1L : 0L};
        return this.composeStateInternal(super.getStateInternal(), NumberFactory.makeByteArray(lArray));
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 32);
        long[] lArray = NumberFactory.makeLongArray(byArray2[0]);
        this.booleanSource = lArray[0];
        this.booleanBitMask = lArray[1];
        this.intSource = lArray[2];
        this.cachedIntSource = lArray[3] != 0L;
        super.setStateInternal(byArray2[1]);
    }

    @Override
    public long nextLong() {
        return this.next();
    }

    @Override
    public int nextInt() {
        if (this.cachedIntSource) {
            this.cachedIntSource = false;
            return NumberFactory.extractLo(this.intSource);
        }
        this.cachedIntSource = true;
        this.intSource = this.nextLong();
        return NumberFactory.extractHi(this.intSource);
    }

    @Override
    public double nextDouble() {
        return NumberFactory.makeDouble(this.nextLong());
    }

    @Override
    public boolean nextBoolean() {
        this.booleanBitMask <<= 1;
        if (this.booleanBitMask == 0L) {
            this.booleanBitMask = 1L;
            this.booleanSource = this.nextLong();
        }
        return (this.booleanSource & this.booleanBitMask) != 0L;
    }

    @Override
    public float nextFloat() {
        return NumberFactory.makeFloat(this.nextInt());
    }

    @Override
    public void nextBytes(byte[] byArray) {
        LongProvider.nextBytesFill(this, byArray, 0, byArray.length);
    }

    @Override
    public void nextBytes(byte[] byArray, int n, int n2) {
        this.checkIndex(0, byArray.length - 1, n);
        this.checkIndex(0, byArray.length - n, n2);
        LongProvider.nextBytesFill(this, byArray, n, n2);
    }

    static void nextBytesFill(RandomLongSource randomLongSource, byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n3 + (n2 & 0x7FFFFFF8);
        while (n3 < n4) {
            long l = randomLongSource.next();
            byArray[n3++] = (byte)l;
            byArray[n3++] = (byte)(l >>> 8);
            byArray[n3++] = (byte)(l >>> 16);
            byArray[n3++] = (byte)(l >>> 24);
            byArray[n3++] = (byte)(l >>> 32);
            byArray[n3++] = (byte)(l >>> 40);
            byArray[n3++] = (byte)(l >>> 48);
            byArray[n3++] = (byte)(l >>> 56);
        }
        int n5 = n + n2;
        if (n3 < n5) {
            long l = randomLongSource.next();
            while (true) {
                byArray[n3++] = (byte)l;
                if (n3 >= n5) break;
                l >>>= 8;
            }
        }
    }
}

