/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.Arrays;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class MersenneTwister64
extends LongProvider {
    private static final int NN = 312;
    private static final int MM = 156;
    private static final long[] MAG01 = new long[]{0L, -5403634167711393303L};
    private static final long UM = Integer.MIN_VALUE;
    private static final long LM = Integer.MAX_VALUE;
    private long[] mt = new long[312];
    private int mti;

    public MersenneTwister64(long[] lArray) {
        this.setSeedInternal(lArray);
    }

    @Override
    protected byte[] getStateInternal() {
        long[] lArray = Arrays.copyOf(this.mt, 313);
        lArray[312] = this.mti;
        return this.composeStateInternal(NumberFactory.makeByteArray(lArray), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 2504);
        long[] lArray = NumberFactory.makeLongArray(byArray2[0]);
        System.arraycopy(lArray, 0, this.mt, 0, 312);
        this.mti = (int)lArray[312];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(long[] lArray) {
        long l;
        int n;
        if (lArray.length == 0) {
            lArray = new long[1];
        }
        this.initState(19650218L);
        int n2 = 1;
        int n3 = 0;
        for (n = Math.max(312, lArray.length); n != 0; --n) {
            l = this.mt[n2 - 1];
            this.mt[n2] = (this.mt[n2] ^ (l ^ l >>> 62) * 3935559000370003845L) + lArray[n3] + (long)n3;
            ++n3;
            if (++n2 >= 312) {
                this.mt[0] = this.mt[311];
                n2 = 1;
            }
            if (n3 < lArray.length) continue;
            n3 = 0;
        }
        for (n = 311; n != 0; --n) {
            l = this.mt[n2 - 1];
            this.mt[n2] = (this.mt[n2] ^ (l ^ l >>> 62) * 2862933555777941757L) - (long)n2;
            if (++n2 < 312) continue;
            this.mt[0] = this.mt[311];
            n2 = 1;
        }
        this.mt[0] = Long.MIN_VALUE;
    }

    private void initState(long l) {
        this.mt[0] = l;
        this.mti = 1;
        while (this.mti < 312) {
            long l2 = this.mt[this.mti - 1];
            this.mt[this.mti] = 6364136223846793005L * (l2 ^ l2 >>> 62) + (long)this.mti;
            ++this.mti;
        }
    }

    @Override
    public long next() {
        long l;
        if (this.mti >= 312) {
            int n;
            for (n = 0; n < 156; ++n) {
                l = this.mt[n] & Integer.MIN_VALUE | this.mt[n + 1] & Integer.MAX_VALUE;
                this.mt[n] = this.mt[n + 156] ^ l >>> 1 ^ MAG01[(int)(l & 1L)];
            }
            for (n = 156; n < 311; ++n) {
                l = this.mt[n] & Integer.MIN_VALUE | this.mt[n + 1] & Integer.MAX_VALUE;
                this.mt[n] = this.mt[n + -156] ^ l >>> 1 ^ MAG01[(int)(l & 1L)];
            }
            l = this.mt[311] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[311] = this.mt[155] ^ l >>> 1 ^ MAG01[(int)(l & 1L)];
            this.mti = 0;
        }
        l = this.mt[this.mti++];
        l ^= l >>> 29 & 0x5555555555555555L;
        l ^= l << 17 & 0x71D67FFFEDA60000L;
        l ^= l << 37 & 0xFFF7EEE000000000L;
        l ^= l >>> 43;
        return l;
    }
}

