/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;

public class GeometricSampler
implements DiscreteSampler {
    private final DiscreteSampler delegate;

    public GeometricSampler(UniformRandomProvider uniformRandomProvider, double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Probability of success (p) must be in the range [0 < p <= 1]: " + d);
        }
        this.delegate = d == 1.0 ? GeometricP1Sampler.INSTANCE : new GeometricExponentialSampler(uniformRandomProvider, d);
    }

    @Override
    public int sample() {
        return this.delegate.sample();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static class GeometricExponentialSampler
    implements DiscreteSampler {
        private final UniformRandomProvider rng;
        private final AhrensDieterExponentialSampler exponentialSampler;

        GeometricExponentialSampler(UniformRandomProvider uniformRandomProvider, double d) {
            this.rng = uniformRandomProvider;
            double d2 = 1.0 / -Math.log1p(-d);
            this.exponentialSampler = new AhrensDieterExponentialSampler(uniformRandomProvider, d2);
        }

        @Override
        public int sample() {
            return (int)Math.floor(this.exponentialSampler.sample());
        }

        public String toString() {
            return "Geometric deviate [" + this.rng.toString() + "]";
        }
    }

    private static class GeometricP1Sampler
    implements DiscreteSampler {
        static final GeometricP1Sampler INSTANCE = new GeometricP1Sampler();

        private GeometricP1Sampler() {
        }

        @Override
        public int sample() {
            return 0;
        }

        public String toString() {
            return "Geometric(p=1) deviate";
        }
    }
}

