/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class MarsagliaNormalizedGaussianSampler
implements NormalizedGaussianSampler {
    private double nextGaussian = Double.NaN;
    private final UniformRandomProvider rng;

    public MarsagliaNormalizedGaussianSampler(UniformRandomProvider uniformRandomProvider) {
        this.rng = uniformRandomProvider;
    }

    @Override
    public double sample() {
        if (Double.isNaN(this.nextGaussian)) {
            double d;
            double d2;
            double d3;
            while (!((d3 = (d2 = 2.0 * this.rng.nextDouble() - 1.0) * d2 + (d = 2.0 * this.rng.nextDouble() - 1.0) * d) < 1.0) || !(d3 > 0.0)) {
            }
            double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
            this.nextGaussian = d4 * d;
            return d4 * d2;
        }
        double d = this.nextGaussian;
        this.nextGaussian = Double.NaN;
        return d;
    }

    public String toString() {
        return "Box-Muller (with rejection) normalized Gaussian deviate [" + this.rng.toString() + "]";
    }
}

