/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import java.security.SecureRandom;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.source32.Well44497b;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.util.NumberFactory;

public final class SeedFactory {
    private static final RandomIntSource SEED_GENERATOR;

    private SeedFactory() {
    }

    public static int createInt() {
        return SeedFactory.createInt(SEED_GENERATOR, System.identityHashCode(new Object()));
    }

    public static long createLong() {
        return SeedFactory.createLong(SEED_GENERATOR, System.identityHashCode(new Object()));
    }

    public static int[] createIntArray(int n) {
        return SeedFactory.createIntArray(n, SEED_GENERATOR, new Object());
    }

    public static long[] createLongArray(int n) {
        return SeedFactory.createLongArray(n, SEED_GENERATOR, new Object());
    }

    static long[] createLongArray(int n, RandomIntSource randomIntSource) {
        return SeedFactory.createLongArray(n, randomIntSource, null);
    }

    static int[] createIntArray(int n, RandomLongSource randomLongSource) {
        return SeedFactory.createIntArray(n, randomLongSource, null);
    }

    static int[] createIntArray(int n, RandomIntSource randomIntSource) {
        return SeedFactory.createIntArray(n, randomIntSource, null);
    }

    private static long[] createLongArray(int n, RandomIntSource randomIntSource, Object object) {
        long[] lArray = new long[n];
        int n2 = System.identityHashCode(object);
        for (int i = 0; i < n; ++i) {
            lArray[i] = SeedFactory.createLong(randomIntSource, n2);
        }
        return lArray;
    }

    private static int[] createIntArray(int n, RandomLongSource randomLongSource, Object object) {
        int[] nArray = new int[n];
        int n2 = System.identityHashCode(object);
        for (int i = 0; i < n; i += 2) {
            long l = SeedFactory.createLong(randomLongSource, n2);
            nArray[i] = NumberFactory.extractHi(l);
            if (i + 1 >= n) continue;
            nArray[i + 1] = NumberFactory.extractLo(l);
        }
        return nArray;
    }

    private static int[] createIntArray(int n, RandomIntSource randomIntSource, Object object) {
        int[] nArray = new int[n];
        int n2 = System.identityHashCode(object);
        for (int i = 0; i < n; ++i) {
            nArray[i] = SeedFactory.createInt(randomIntSource, n2);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long createLong(RandomLongSource randomLongSource, int n) {
        RandomLongSource randomLongSource2 = randomLongSource;
        synchronized (randomLongSource2) {
            return randomLongSource.next() ^ NumberFactory.makeLong(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long createLong(RandomIntSource randomIntSource, int n) {
        RandomIntSource randomIntSource2 = randomIntSource;
        synchronized (randomIntSource2) {
            return NumberFactory.makeLong(randomIntSource.next() ^ n, randomIntSource.next() ^ n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createInt(RandomIntSource randomIntSource, int n) {
        RandomIntSource randomIntSource2 = randomIntSource;
        synchronized (randomIntSource2) {
            return randomIntSource.next() ^ n;
        }
    }

    static {
        SecureRandom secureRandom = new SecureRandom();
        long l = NumberFactory.makeLong(secureRandom.generateSeed(8));
        SplitMix64 splitMix64 = new SplitMix64(l);
        SEED_GENERATOR = new Well44497b(SeedFactory.createIntArray(1391, splitMix64));
    }
}

