/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.IntervalUtils;
import org.apache.commons.math4.util.FastMath;

public class WilsonScoreInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double alpha = (1.0 - confidenceLevel) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        double z = normalDistribution.inverseCumulativeProbability(1.0 - alpha);
        double zSquared = z * z;
        double oneOverNumTrials = 1.0 / (double)numberOfTrials;
        double zSquaredOverNumTrials = zSquared * oneOverNumTrials;
        double mean = oneOverNumTrials * (double)numberOfSuccesses;
        double factor = 1.0 / (1.0 + zSquaredOverNumTrials);
        double modifiedSuccessRatio = mean + zSquaredOverNumTrials / 2.0;
        double difference = z * FastMath.sqrt(oneOverNumTrials * mean * (1.0 - mean) + oneOverNumTrials * zSquaredOverNumTrials / 4.0);
        double lowerBound = factor * (modifiedSuccessRatio - difference);
        double upperBound = factor * (modifiedSuccessRatio + difference);
        return new ConfidenceInterval(lowerBound, upperBound, confidenceLevel);
    }
}

