/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo128
extends IntProvider {
    private static final int SEED_SIZE = 4;
    protected int state0;
    protected int state1;
    protected int state2;
    protected int state3;

    AbstractXoShiRo128(int[] seed) {
        if (seed.length < 4) {
            int[] state = new int[4];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoShiRo128(int seed0, int seed1, int seed2, int seed3) {
        this.state0 = seed0;
        this.state1 = seed1;
        this.state2 = seed2;
        this.state3 = seed3;
    }

    private void setState(int[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
        this.state2 = state[2];
        this.state3 = state[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new int[]{this.state0, this.state1, this.state2, this.state3}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        this.setState(NumberFactory.makeIntArray(c[0]));
        super.setStateInternal(c[1]);
    }
}

