/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo256
extends LongProvider {
    private static final int SEED_SIZE = 4;
    protected long state0;
    protected long state1;
    protected long state2;
    protected long state3;

    AbstractXoShiRo256(long[] seed) {
        if (seed.length < 4) {
            long[] state = new long[4];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoShiRo256(long seed0, long seed1, long seed2, long seed3) {
        this.state0 = seed0;
        this.state1 = seed1;
        this.state2 = seed2;
        this.state3 = seed3;
    }

    private void setState(long[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
        this.state2 = state[2];
        this.state3 = state[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1, this.state2, this.state3}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 32);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }
}

