/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class ChengBetaSampler
extends SamplerBase
implements ContinuousSampler {
    private final double alphaShape;
    private final double betaShape;
    private final UniformRandomProvider rng;

    public ChengBetaSampler(UniformRandomProvider rng, double alpha, double beta) {
        super(null);
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha is not strictly positive: " + alpha);
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta is not strictly positive: " + beta);
        }
        this.rng = rng;
        this.alphaShape = alpha;
        this.betaShape = beta;
    }

    @Override
    public double sample() {
        double a = Math.min(this.alphaShape, this.betaShape);
        double b = Math.max(this.alphaShape, this.betaShape);
        if (a > 1.0) {
            return this.algorithmBB(a, b);
        }
        return this.algorithmBC(b, a);
    }

    @Override
    public String toString() {
        return "Cheng Beta deviate [" + this.rng.toString() + "]";
    }

    private double algorithmBB(double a, double b) {
        double t;
        double u2;
        double z;
        double w;
        double u1;
        double v;
        double r;
        double s;
        double alpha = a + b;
        double beta = Math.sqrt((alpha - 2.0) / (2.0 * a * b - alpha));
        double gamma = a + 1.0 / beta;
        do {
            u1 = this.rng.nextDouble();
            u2 = this.rng.nextDouble();
        } while (!((s = a + (r = gamma * (v = beta * (Math.log(u1) - Math.log1p(-u1))) - 1.3862944) - (w = a * Math.exp(v))) + 2.609438 >= 5.0 * (z = u1 * u1 * u2)) && !(s >= (t = Math.log(z))) && r + alpha * (Math.log(alpha) - Math.log(b + w)) < t);
        w = Math.min(w, Double.MAX_VALUE);
        return this.equals(a, this.alphaShape) ? w / (b + w) : b / (b + w);
    }

    private double algorithmBC(double a, double b) {
        double w;
        double alpha = a + b;
        double beta = 1.0 / b;
        double delta = 1.0 + a - b;
        double k1 = delta * (0.0138889 + 0.0416667 * b) / (a * beta - 0.777778);
        double k2 = 0.25 + (0.5 + 0.25 / delta) * b;
        while (true) {
            double v;
            double u1 = this.rng.nextDouble();
            double u2 = this.rng.nextDouble();
            double y = u1 * u2;
            double z = u1 * y;
            if (u1 < 0.5) {
                if (0.25 * u2 + z - y >= k1) {
                    continue;
                }
            } else {
                if (z <= 0.25) {
                    v = beta * (Math.log(u1) - Math.log1p(-u1));
                    w = a * Math.exp(v);
                    break;
                }
                if (z >= k2) continue;
            }
            v = beta * (Math.log(u1) - Math.log1p(-u1));
            w = a * Math.exp(v);
            if (alpha * (Math.log(alpha) - Math.log(b + w) + v) - 1.3862944 >= Math.log(z)) break;
        }
        w = Math.min(w, Double.MAX_VALUE);
        return this.equals(a, this.alphaShape) ? w / (b + w) : b / (b + w);
    }

    private boolean equals(double a, double b) {
        return Math.abs(a - b) <= Double.MIN_VALUE;
    }
}

