/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongToDoubleFunction;

public class InterpolatingLongDoubleSampler
implements LongToDoubleFunction {
    private final double[] lut;
    private final DoubleUnaryOperator f;
    private int resolution;
    private final boolean clamp;
    private final double clampMax;
    private ThreadSafeHash hash;

    public InterpolatingLongDoubleSampler(DoubleUnaryOperator icdSource, int resolution, boolean hash, boolean clamp, double clampMax) {
        this.f = icdSource;
        this.resolution = resolution;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        this.clamp = clamp;
        this.clampMax = clampMax;
        this.lut = this.precompute();
    }

    private double[] precompute() {
        double[] precomputed = new double[this.resolution + 2];
        for (int s = 0; s <= this.resolution; ++s) {
            double sampleValue;
            double rangedToUnit = (double)s / (double)this.resolution;
            precomputed[s] = sampleValue = this.clamp ? Double.min(this.clampMax, this.f.applyAsDouble(rangedToUnit)) : this.f.applyAsDouble(rangedToUnit);
        }
        precomputed[precomputed.length - 1] = 0.0;
        return precomputed;
    }

    @Override
    public double applyAsDouble(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        double samplePoint = unit * (double)this.resolution;
        int leftidx = (int)samplePoint;
        double leftPartial = samplePoint - (double)leftidx;
        double leftComponent = this.lut[leftidx] * (1.0 - leftPartial);
        double rightComponent = this.lut[leftidx + 1] * leftPartial;
        double sample = leftComponent + rightComponent;
        return sample;
    }
}

