/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class KISSRandom
extends IntProvider {
    private static final int SEED_SIZE = 4;
    private int z;
    private int w;
    private int jsr;
    private int jcong;

    public KISSRandom(int[] seed) {
        this.setSeedInternal(seed);
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new int[]{this.z, this.w, this.jsr, this.jcong}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        int[] tmp = NumberFactory.makeIntArray(c[0]);
        this.z = tmp[0];
        this.w = tmp[1];
        this.jsr = tmp[2];
        this.jcong = tmp[3];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(int[] seed) {
        int[] tmp = new int[4];
        this.fillState(tmp, seed);
        this.z = tmp[0];
        this.w = tmp[1];
        this.jsr = tmp[2];
        this.jcong = tmp[3];
    }

    @Override
    public int next() {
        this.z = this.computeNew(36969, this.z);
        this.w = this.computeNew(18000, this.w);
        int mwc = (this.z << 16) + this.w;
        this.jsr ^= this.jsr << 13;
        this.jsr ^= this.jsr >>> 17;
        this.jsr ^= this.jsr << 5;
        this.jcong = 69069 * this.jcong + 1234567;
        return (mwc ^ this.jcong) + this.jsr;
    }

    private int computeNew(int mult, int previous) {
        return mult * (previous & 0xFFFF) + (previous >>> 16);
    }
}

