/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public class RealIntDoubleSampler
implements IntToDoubleFunction {
    private final DoubleUnaryOperator f;
    private final boolean clamp;
    private final double clampMax;
    private ThreadSafeHash hash;

    public RealIntDoubleSampler(DoubleUnaryOperator parentFunc, boolean hash, boolean clamp, double clampMax) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        this.clamp = clamp;
        this.clampMax = clampMax;
    }

    @Override
    public double applyAsDouble(int input) {
        long value = input;
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        double sample = this.clamp ? Double.min(this.clampMax, this.f.applyAsDouble(unit)) : this.f.applyAsDouble(unit);
        return sample;
    }
}

