/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive;

import io.virtdata.shaded.oac.statistics.descriptive.UnivariateStatistic;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    @Override
    public double evaluate(double[] dArray) throws MathIllegalArgumentException {
        MathArrays.verifyValues(dArray, 0, 0);
        return this.evaluate(dArray, 0, dArray.length);
    }

    @Override
    public abstract double evaluate(double[] var1, int var2, int var3) throws MathIllegalArgumentException;

    @Override
    public abstract UnivariateStatistic copy();

    public void setData(double[] dArray) {
        this.storedData = dArray == null ? null : (double[])dArray.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        if (n + n2 > dArray.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(n + n2), dArray.length, true);
        }
        this.storedData = new double[n2];
        System.arraycopy(dArray, n, this.storedData, 0, n2);
    }

    public double evaluate() throws MathIllegalArgumentException {
        return this.evaluate(this.storedData);
    }
}

