/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformContinuousSampler;

abstract class AbstractContinuousDistribution
implements ContinuousDistribution {
    AbstractContinuousDistribution() {
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        boolean bl;
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        double d3 = this.getSupportLowerBound();
        if (d == 0.0) {
            return d3;
        }
        double d4 = this.getSupportUpperBound();
        if (d == 1.0) {
            return d4;
        }
        double d5 = this.getMean();
        double d6 = Math.sqrt(this.getVariance());
        boolean bl2 = bl = !Double.isInfinite(d5) && !Double.isNaN(d5) && !Double.isInfinite(d6) && !Double.isNaN(d6);
        if (d3 == Double.NEGATIVE_INFINITY) {
            if (bl) {
                d3 = d5 - d6 * Math.sqrt((1.0 - d) / d);
            } else {
                d3 = -1.0;
                while (this.cumulativeProbability(d3) >= d) {
                    d3 *= 2.0;
                }
            }
        }
        if (d4 == Double.POSITIVE_INFINITY) {
            if (bl) {
                d4 = d5 + d6 * Math.sqrt(d / (1.0 - d));
            } else {
                d4 = 1.0;
                while (this.cumulativeProbability(d4) < d) {
                    d4 *= 2.0;
                }
            }
        }
        double d7 = new BrentSolver(1.0E-14, 1.0E-9, 1.0E-15).solve(d2 -> this.cumulativeProbability(d2) - d, d3, 0.5 * (d3 + d4), d4);
        if (!this.isSupportConnected() && d7 - 1.0E-9 >= this.getSupportLowerBound()) {
            double d8 = this.cumulativeProbability(d7);
            if (this.cumulativeProbability(d7 - 1.0E-9) == d8) {
                d4 = d7;
                while (d4 - d3 > 1.0E-9) {
                    double d9 = 0.5 * (d3 + d4);
                    if (this.cumulativeProbability(d9) < d8) {
                        d3 = d9;
                        continue;
                    }
                    d4 = d9;
                }
                return d4;
            }
        }
        return d7;
    }

    public static double[] sample(int n, ContinuousDistribution.Sampler sampler) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sampler.sample();
        }
        return dArray;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new InverseTransformContinuousSampler(uniformRandomProvider, AbstractContinuousDistribution.this.createICPF());
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }

    private ContinuousInverseCumulativeProbabilityFunction createICPF() {
        return new ContinuousInverseCumulativeProbabilityFunction(){

            @Override
            public double inverseCumulativeProbability(double d) {
                return AbstractContinuousDistribution.this.inverseCumulativeProbability(d);
            }
        };
    }

    private static class BrentSolver {
        private final double relativeAccuracy;
        private final double absoluteAccuracy;
        private final double functionValueAccuracy;

        BrentSolver(double d, double d2, double d3) {
            this.relativeAccuracy = d;
            this.absoluteAccuracy = d2;
            this.functionValueAccuracy = d3;
        }

        double solve(DoubleUnaryOperator doubleUnaryOperator, double d, double d2, double d3) {
            if (d > d3) {
                throw new DistributionException("{0} > {1}", d, d3);
            }
            if (d2 < d || d2 > d3) {
                throw new DistributionException("Number {0} is out of range [{1}, {2}]", d2, d, d3);
            }
            double d4 = doubleUnaryOperator.applyAsDouble(d2);
            if (Math.abs(d4) <= this.functionValueAccuracy) {
                return d2;
            }
            double d5 = doubleUnaryOperator.applyAsDouble(d);
            if (Math.abs(d5) <= this.functionValueAccuracy) {
                return d;
            }
            if (d4 * d5 < 0.0) {
                return this.brent(doubleUnaryOperator, d, d2, d5, d4);
            }
            double d6 = doubleUnaryOperator.applyAsDouble(d3);
            if (Math.abs(d6) <= this.functionValueAccuracy) {
                return d3;
            }
            if (d4 * d6 < 0.0) {
                return this.brent(doubleUnaryOperator, d2, d3, d4, d6);
            }
            throw new DistributionException("No bracketing: f({0})={1}, f({2})={3}", d, d5, d3, d6);
        }

        private double brent(DoubleUnaryOperator doubleUnaryOperator, double d, double d2, double d3, double d4) {
            double d5;
            double d6 = d;
            double d7 = d3;
            double d8 = d2;
            double d9 = d4;
            double d10 = d6;
            double d11 = d7;
            double d12 = d5 = d8 - d6;
            double d13 = this.absoluteAccuracy;
            double d14 = this.relativeAccuracy;
            while (true) {
                if (Math.abs(d11) < Math.abs(d9)) {
                    d6 = d8;
                    d8 = d10;
                    d10 = d6;
                    d7 = d9;
                    d9 = d11;
                    d11 = d7;
                }
                double d15 = 2.0 * d14 * Math.abs(d8) + d13;
                double d16 = 0.5 * (d10 - d8);
                if (Math.abs(d16) <= d15 || Precision.equals(d9, 0.0)) {
                    return d8;
                }
                if (Math.abs(d12) < d15 || Math.abs(d7) <= Math.abs(d9)) {
                    d12 = d5 = d16;
                } else {
                    double d17;
                    double d18;
                    double d19 = d9 / d7;
                    if (d6 == d10) {
                        d18 = 2.0 * d16 * d19;
                        d17 = 1.0 - d19;
                    } else {
                        d17 = d7 / d11;
                        double d20 = d9 / d11;
                        d18 = d19 * (2.0 * d16 * d17 * (d17 - d20) - (d8 - d6) * (d20 - 1.0));
                        d17 = (d17 - 1.0) * (d20 - 1.0) * (d19 - 1.0);
                    }
                    if (d18 > 0.0) {
                        d17 = -d17;
                    } else {
                        d18 = -d18;
                    }
                    d19 = d12;
                    d12 = d5;
                    if (d18 >= 1.5 * d16 * d17 - Math.abs(d15 * d17) || d18 >= Math.abs(0.5 * d19 * d17)) {
                        d12 = d5 = d16;
                    } else {
                        d5 = d18 / d17;
                    }
                }
                d6 = d8;
                d7 = d9;
                d8 = Math.abs(d5) > d15 ? (d8 += d5) : (d16 > 0.0 ? (d8 += d15) : (d8 -= d15));
                d9 = doubleUnaryOperator.applyAsDouble(d8);
                if (!(d9 > 0.0 && d11 > 0.0) && (!(d9 <= 0.0) || !(d11 <= 0.0))) continue;
                d10 = d6;
                d11 = d7;
                d12 = d5 = d8 - d6;
            }
        }
    }
}

