/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;

public interface ContinuousDistribution {
    default public double probability(double d) {
        return 0.0;
    }

    default public double probability(double d, double d2) {
        if (d > d2) {
            throw new DistributionException("{0} > {1}", d, d2);
        }
        return this.cumulativeProbability(d2) - this.cumulativeProbability(d);
    }

    public double density(double var1);

    default public double logDensity(double d) {
        return Math.log(this.density(d));
    }

    public double cumulativeProbability(double var1);

    public double inverseCumulativeProbability(double var1);

    public double getMean();

    public double getVariance();

    public double getSupportLowerBound();

    public double getSupportUpperBound();

    public boolean isSupportConnected();

    public Sampler createSampler(UniformRandomProvider var1);

    public static interface Sampler {
        public double sample();
    }
}

