/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.LogGamma;

public class WeibullDistribution
extends AbstractContinuousDistribution {
    private final double shape;
    private final double scale;

    public WeibullDistribution(double d, double d2) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.scale = d2;
        this.shape = d;
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        double d2 = d / this.scale;
        double d3 = Math.pow(d2, this.shape - 1.0);
        double d4 = d3 * d2;
        return this.shape / this.scale * d3 * Math.exp(-d4);
    }

    @Override
    public double logDensity(double d) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = d / this.scale;
        double d3 = Math.log(d2) * (this.shape - 1.0);
        double d4 = Math.exp(d3) * d2;
        return Math.log(this.shape / this.scale) + d3 - d4;
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = d <= 0.0 ? 0.0 : 1.0 - Math.exp(-Math.pow(d / this.scale, this.shape));
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        double d2 = d == 0.0 ? 0.0 : (d == 1.0 ? Double.POSITIVE_INFINITY : this.scale * Math.pow(-Math.log1p(-d), 1.0 / this.shape));
        return d2;
    }

    @Override
    public double getMean() {
        double d = this.getShape();
        double d2 = this.getScale();
        return d2 * Math.exp(LogGamma.value(1.0 + 1.0 / d));
    }

    @Override
    public double getVariance() {
        double d = this.getShape();
        double d2 = this.getScale();
        double d3 = this.getMean();
        return d2 * d2 * Math.exp(LogGamma.value(1.0 + 2.0 / d)) - d3 * d3;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

