/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.differentiation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.arrays.LinearCombination;
import org.apache.commons.numbers.combinatorics.FactorialDouble;

public class DSCompiler {
    private static FactorialDouble FACTORIAL = FactorialDouble.create().withCache(30);
    private static AtomicReference<DSCompiler[][]> compilers = new AtomicReference<Object>(null);
    private final int parameters;
    private final int order;
    private final int[][] sizes;
    private final int[][] derivativesIndirection;
    private final int[] lowerIndirection;
    private final int[][][] multIndirection;
    private final int[][][] compIndirection;

    private DSCompiler(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2) throws NumberIsTooLargeException {
        this.parameters = n;
        this.order = n2;
        this.sizes = DSCompiler.compileSizes(n, n2, dSCompiler);
        this.derivativesIndirection = DSCompiler.compileDerivativesIndirection(n, n2, dSCompiler, dSCompiler2);
        this.lowerIndirection = DSCompiler.compileLowerIndirection(n, n2, dSCompiler, dSCompiler2);
        this.multIndirection = DSCompiler.compileMultiplicationIndirection(n, n2, dSCompiler, dSCompiler2, this.lowerIndirection);
        this.compIndirection = DSCompiler.compileCompositionIndirection(n, n2, dSCompiler, dSCompiler2, this.sizes, this.derivativesIndirection);
    }

    public static DSCompiler getCompiler(int n, int n2) throws NumberIsTooLargeException {
        int n3;
        DSCompiler[][] dSCompilerArray = compilers.get();
        if (dSCompilerArray != null && dSCompilerArray.length > n && dSCompilerArray[n].length > n2 && dSCompilerArray[n][n2] != null) {
            return dSCompilerArray[n][n2];
        }
        int n4 = FastMath.max(n, dSCompilerArray == null ? 0 : dSCompilerArray.length);
        int n5 = FastMath.max(n2, dSCompilerArray == null ? 0 : dSCompilerArray[0].length);
        DSCompiler[][] dSCompilerArray2 = new DSCompiler[n4 + 1][n5 + 1];
        if (dSCompilerArray != null) {
            for (n3 = 0; n3 < dSCompilerArray.length; ++n3) {
                System.arraycopy(dSCompilerArray[n3], 0, dSCompilerArray2[n3], 0, dSCompilerArray[n3].length);
            }
        }
        for (n3 = 0; n3 <= n + n2; ++n3) {
            for (int i = FastMath.max(0, n3 - n); i <= FastMath.min(n2, n3); ++i) {
                int n6 = n3 - i;
                if (dSCompilerArray2[n6][i] != null) continue;
                DSCompiler dSCompiler = n6 == 0 ? null : dSCompilerArray2[n6 - 1][i];
                DSCompiler dSCompiler2 = i == 0 ? null : dSCompilerArray2[n6][i - 1];
                dSCompilerArray2[n6][i] = new DSCompiler(n6, i, dSCompiler, dSCompiler2);
            }
        }
        compilers.compareAndSet(dSCompilerArray, dSCompilerArray2);
        return dSCompilerArray2[n][n2];
    }

    private static int[][] compileSizes(int n, int n2, DSCompiler dSCompiler) {
        int[][] nArray = new int[n + 1][n2 + 1];
        if (n == 0) {
            Arrays.fill(nArray[0], 1);
        } else {
            System.arraycopy(dSCompiler.sizes, 0, nArray, 0, n);
            nArray[n][0] = 1;
            for (int i = 0; i < n2; ++i) {
                nArray[n][i + 1] = nArray[n][i] + nArray[n - 1][i + 1];
            }
        }
        return nArray;
    }

    private static int[][] compileDerivativesIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return new int[1][n];
        }
        int n4 = dSCompiler.derivativesIndirection.length;
        int n5 = dSCompiler2.derivativesIndirection.length;
        int[][] nArray = new int[n4 + n5][n];
        for (n3 = 0; n3 < n4; ++n3) {
            System.arraycopy(dSCompiler.derivativesIndirection[n3], 0, nArray[n3], 0, n - 1);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            System.arraycopy(dSCompiler2.derivativesIndirection[n3], 0, nArray[n4 + n3], 0, n);
            int[] nArray2 = nArray[n4 + n3];
            int n6 = n - 1;
            nArray2[n6] = nArray2[n6] + 1;
        }
        return nArray;
    }

    private static int[] compileLowerIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2) {
        if (n == 0 || n2 <= 1) {
            return new int[]{0};
        }
        int n3 = dSCompiler.lowerIndirection.length;
        int n4 = dSCompiler2.lowerIndirection.length;
        int[] nArray = new int[n3 + n4];
        System.arraycopy(dSCompiler.lowerIndirection, 0, nArray, 0, n3);
        for (int i = 0; i < n4; ++i) {
            nArray[n3 + i] = dSCompiler.getSize() + dSCompiler2.lowerIndirection[i];
        }
        return nArray;
    }

    private static int[][][] compileMultiplicationIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2, int[] nArray) {
        if (n == 0 || n2 == 0) {
            return new int[][][]{new int[][]{{1, 0, 0}}};
        }
        int n3 = dSCompiler.multIndirection.length;
        int n4 = dSCompiler2.multIndirection.length;
        int[][][] nArrayArray = new int[n3 + n4][][];
        System.arraycopy(dSCompiler.multIndirection, 0, nArrayArray, 0, n3);
        for (int i = 0; i < n4; ++i) {
            int[][] nArray2 = dSCompiler2.multIndirection[i];
            ArrayList<int[]> arrayList = new ArrayList<int[]>(nArray2.length * 2);
            for (int j = 0; j < nArray2.length; ++j) {
                arrayList.add(new int[]{nArray2[j][0], nArray[nArray2[j][1]], n3 + nArray2[j][2]});
                arrayList.add(new int[]{nArray2[j][0], n3 + nArray2[j][1], nArray[nArray2[j][2]]});
            }
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>(arrayList.size());
            for (int j = 0; j < arrayList.size(); ++j) {
                int[] nArray3 = (int[])arrayList.get(j);
                if (nArray3[0] <= 0) continue;
                for (int k = j + 1; k < arrayList.size(); ++k) {
                    int[] nArray4 = (int[])arrayList.get(k);
                    if (nArray3[1] != nArray4[1] || nArray3[2] != nArray4[2]) continue;
                    nArray3[0] = nArray3[0] + nArray4[0];
                    nArray4[0] = 0;
                }
                arrayList2.add(nArray3);
            }
            nArrayArray[n3 + i] = (int[][])arrayList2.toArray((T[])new int[arrayList2.size()][]);
        }
        return nArrayArray;
    }

    private static int[][][] compileCompositionIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2, int[][] nArray, int[][] nArray2) throws NumberIsTooLargeException {
        if (n == 0 || n2 == 0) {
            return new int[][][]{new int[][]{{1, 0}}};
        }
        int n3 = dSCompiler.compIndirection.length;
        int n4 = dSCompiler2.compIndirection.length;
        int[][][] nArrayArray = new int[n3 + n4][][];
        System.arraycopy(dSCompiler.compIndirection, 0, nArrayArray, 0, n3);
        for (int i = 0; i < n4; ++i) {
            int n5;
            int[] nArray3;
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            for (int[] nArray4 : dSCompiler2.compIndirection[i]) {
                nArray3 = new int[nArray4.length + 1];
                nArray3[0] = nArray4[0];
                nArray3[1] = nArray4[1] + 1;
                int[] nArray5 = new int[n];
                nArray5[n - 1] = 1;
                nArray3[nArray4.length] = DSCompiler.getPartialDerivativeIndex(n, n2, nArray, nArray5);
                for (n5 = 2; n5 < nArray4.length; ++n5) {
                    nArray3[n5] = DSCompiler.convertIndex(nArray4[n5], n, dSCompiler2.derivativesIndirection, n, n2, nArray);
                }
                Arrays.sort(nArray3, 2, nArray3.length);
                arrayList.add(nArray3);
                for (n5 = 2; n5 < nArray4.length; ++n5) {
                    int[] nArray6 = new int[nArray4.length];
                    nArray6[0] = nArray4[0];
                    nArray6[1] = nArray4[1];
                    for (int j = 2; j < nArray4.length; ++j) {
                        nArray6[j] = DSCompiler.convertIndex(nArray4[j], n, dSCompiler2.derivativesIndirection, n, n2, nArray);
                        if (j != n5) continue;
                        System.arraycopy(nArray2[nArray6[j]], 0, nArray5, 0, n);
                        int n6 = n - 1;
                        nArray5[n6] = nArray5[n6] + 1;
                        nArray6[j] = DSCompiler.getPartialDerivativeIndex(n, n2, nArray, nArray5);
                    }
                    Arrays.sort(nArray6, 2, nArray6.length);
                    arrayList.add(nArray6);
                }
            }
            Object object = new ArrayList(arrayList.size());
            for (int j = 0; j < arrayList.size(); ++j) {
                int[] nArray7 = (int[])arrayList.get(j);
                if (nArray7[0] <= 0) continue;
                for (int k = j + 1; k < arrayList.size(); ++k) {
                    nArray3 = (int[])arrayList.get(k);
                    boolean bl = nArray7.length == nArray3.length;
                    for (n5 = 1; bl && n5 < nArray7.length; bl &= nArray7[n5] == nArray3[n5], ++n5) {
                    }
                    if (!bl) continue;
                    nArray7[0] = nArray7[0] + nArray3[0];
                    nArray3[0] = 0;
                }
                object.add(nArray7);
            }
            nArrayArray[n3 + i] = (int[][])object.toArray((T[])new int[object.size()][]);
        }
        return nArrayArray;
    }

    public int getPartialDerivativeIndex(int ... nArray) throws DimensionMismatchException, NumberIsTooLargeException {
        if (nArray.length != this.getFreeParameters()) {
            throw new DimensionMismatchException(nArray.length, this.getFreeParameters());
        }
        return DSCompiler.getPartialDerivativeIndex(this.parameters, this.order, this.sizes, nArray);
    }

    private static int getPartialDerivativeIndex(int n, int n2, int[][] nArray, int ... nArray2) throws NumberIsTooLargeException {
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        for (int i = n - 1; i >= 0; --i) {
            int n6 = nArray2[i];
            if ((n5 += n6) > n2) {
                throw new NumberIsTooLargeException(n5, (Number)n2, true);
            }
            while (n6-- > 0) {
                n3 += nArray[i][n4--];
            }
        }
        return n3;
    }

    private static int convertIndex(int n, int n2, int[][] nArray, int n3, int n4, int[][] nArray2) throws NumberIsTooLargeException {
        int[] nArray3 = new int[n3];
        System.arraycopy(nArray[n], 0, nArray3, 0, FastMath.min(n2, n3));
        return DSCompiler.getPartialDerivativeIndex(n3, n4, nArray2, nArray3);
    }

    public int[] getPartialDerivativeOrders(int n) {
        return this.derivativesIndirection[n];
    }

    public int getFreeParameters() {
        return this.parameters;
    }

    public int getOrder() {
        return this.order;
    }

    public int getSize() {
        return this.sizes[this.parameters][this.order];
    }

    public void linearCombination(double d, double[] dArray, int n, double d2, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i = 0; i < this.getSize(); ++i) {
            dArray3[n3 + i] = LinearCombination.value(d, dArray[n + i], d2, dArray2[n2 + i]);
        }
    }

    public void linearCombination(double d, double[] dArray, int n, double d2, double[] dArray2, int n2, double d3, double[] dArray3, int n3, double[] dArray4, int n4) {
        for (int i = 0; i < this.getSize(); ++i) {
            dArray4[n4 + i] = LinearCombination.value(d, dArray[n + i], d2, dArray2[n2 + i], d3, dArray3[n3 + i]);
        }
    }

    public void linearCombination(double d, double[] dArray, int n, double d2, double[] dArray2, int n2, double d3, double[] dArray3, int n3, double d4, double[] dArray4, int n4, double[] dArray5, int n5) {
        for (int i = 0; i < this.getSize(); ++i) {
            dArray5[n5 + i] = LinearCombination.value(d, dArray[n + i], d2, dArray2[n2 + i], d3, dArray3[n3 + i], d4, dArray4[n4 + i]);
        }
    }

    public void add(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i = 0; i < this.getSize(); ++i) {
            dArray3[n3 + i] = dArray[n + i] + dArray2[n2 + i];
        }
    }

    public void subtract(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i = 0; i < this.getSize(); ++i) {
            dArray3[n3 + i] = dArray[n + i] - dArray2[n2 + i];
        }
    }

    public void multiply(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i = 0; i < this.multIndirection.length; ++i) {
            int[][] nArray = this.multIndirection[i];
            double d = 0.0;
            for (int j = 0; j < nArray.length; ++j) {
                d += (double)nArray[j][0] * dArray[n + nArray[j][1]] * dArray2[n2 + nArray[j][2]];
            }
            dArray3[n3 + i] = d;
        }
    }

    public void divide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = new double[this.getSize()];
        this.pow(dArray2, n, -1, dArray4, 0);
        this.multiply(dArray, n, dArray4, 0, dArray3, n3);
    }

    public void remainder(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double d = FastMath.IEEEremainder(dArray[n], dArray2[n2]);
        double d2 = FastMath.rint((dArray[n] - d) / dArray2[n2]);
        dArray3[n3] = d;
        for (int i = 1; i < this.getSize(); ++i) {
            dArray3[n3 + i] = dArray[n + i] - d2 * dArray2[n2 + i];
        }
    }

    public void pow(double d, double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        if (d == 0.0) {
            if (dArray[n] == 0.0) {
                dArray3[0] = 1.0;
                double d2 = Double.POSITIVE_INFINITY;
                for (int i = 1; i < dArray3.length; ++i) {
                    dArray3[i] = d2 = -d2;
                }
            } else if (dArray[n] < 0.0) {
                Arrays.fill(dArray3, Double.NaN);
            }
        } else {
            dArray3[0] = FastMath.pow(d, dArray[n]);
            double d3 = FastMath.log(d);
            for (int i = 1; i < dArray3.length; ++i) {
                dArray3[i] = d3 * dArray3[i - 1];
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void pow(double[] dArray, int n, double d, double[] dArray2, int n2) {
        if (d == 0.0) {
            dArray2[n2] = 1.0;
            Arrays.fill(dArray2, n2 + 1, n2 + this.getSize(), 0.0);
            return;
        }
        if (dArray[n] == 0.0) {
            Arrays.fill(dArray2, n2, n2 + this.getSize(), 0.0);
            return;
        }
        double[] dArray3 = new double[1 + this.order];
        double d2 = FastMath.pow(dArray[n], d - (double)this.order);
        for (int i = this.order; i > 0; --i) {
            dArray3[i] = d2;
            d2 *= dArray[n];
        }
        dArray3[0] = d2;
        double d3 = d;
        for (int i = 1; i <= this.order; ++i) {
            int n3 = i;
            dArray3[n3] = dArray3[n3] * d3;
            d3 *= d - (double)i;
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void pow(double[] dArray, int n, int n2, double[] dArray2, int n3) {
        if (n2 == 0) {
            dArray2[n3] = 1.0;
            Arrays.fill(dArray2, n3 + 1, n3 + this.getSize(), 0.0);
            return;
        }
        double[] dArray3 = new double[1 + this.order];
        if (n2 > 0) {
            int n4 = FastMath.min(this.order, n2);
            double d = FastMath.pow(dArray[n], n2 - n4);
            for (int i = n4; i > 0; --i) {
                dArray3[i] = d;
                d *= dArray[n];
            }
            dArray3[0] = d;
        } else {
            double d = 1.0 / dArray[n];
            double d2 = FastMath.pow(d, -n2);
            for (int i = 0; i <= this.order; ++i) {
                dArray3[i] = d2;
                d2 *= d;
            }
        }
        double d = n2;
        for (int i = 1; i <= this.order; ++i) {
            int n5 = i;
            dArray3[n5] = dArray3[n5] * d;
            d *= (double)(n2 - i);
        }
        this.compose(dArray, n, dArray3, dArray2, n3);
    }

    public void pow(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = new double[this.getSize()];
        this.log(dArray, n, dArray4, 0);
        double[] dArray5 = new double[this.getSize()];
        this.multiply(dArray4, 0, dArray2, n2, dArray5, 0);
        this.exp(dArray5, 0, dArray3, n3);
    }

    public void rootN(double[] dArray, int n, int n2, double[] dArray2, int n3) {
        double d;
        double[] dArray3 = new double[1 + this.order];
        if (n2 == 2) {
            dArray3[0] = FastMath.sqrt(dArray[n]);
            d = 0.5 / dArray3[0];
        } else if (n2 == 3) {
            dArray3[0] = FastMath.cbrt(dArray[n]);
            d = 1.0 / (3.0 * dArray3[0] * dArray3[0]);
        } else {
            dArray3[0] = FastMath.pow(dArray[n], 1.0 / (double)n2);
            d = 1.0 / ((double)n2 * FastMath.pow(dArray3[0], n2 - 1));
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 1.0 / dArray[n];
        for (int i = 1; i <= this.order; ++i) {
            dArray3[i] = d;
            d *= d3 * (d2 - (double)i);
        }
        this.compose(dArray, n, dArray3, dArray2, n3);
    }

    public void exp(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        Arrays.fill(dArray3, FastMath.exp(dArray[n]));
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void expm1(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.expm1(dArray[n]);
        Arrays.fill(dArray3, 1, 1 + this.order, FastMath.exp(dArray[n]));
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void log(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.log(dArray[n]);
        if (this.order > 0) {
            double d;
            double d2 = d = 1.0 / dArray[n];
            for (int i = 1; i <= this.order; ++i) {
                dArray3[i] = d2;
                d2 *= (double)(-i) * d;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void log1p(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.log1p(dArray[n]);
        if (this.order > 0) {
            double d;
            double d2 = d = 1.0 / (1.0 + dArray[n]);
            for (int i = 1; i <= this.order; ++i) {
                dArray3[i] = d2;
                d2 *= (double)(-i) * d;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void log10(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.log10(dArray[n]);
        if (this.order > 0) {
            double d = 1.0 / dArray[n];
            double d2 = d / FastMath.log(10.0);
            for (int i = 1; i <= this.order; ++i) {
                dArray3[i] = d2;
                d2 *= (double)(-i) * d;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void cos(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.cos(dArray[n]);
        if (this.order > 0) {
            dArray3[1] = -FastMath.sin(dArray[n]);
            for (int i = 2; i <= this.order; ++i) {
                dArray3[i] = -dArray3[i - 2];
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void sin(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.sin(dArray[n]);
        if (this.order > 0) {
            dArray3[1] = FastMath.cos(dArray[n]);
            for (int i = 2; i <= this.order; ++i) {
                dArray3[i] = -dArray3[i - 2];
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void tan(double[] dArray, int n, double[] dArray2, int n2) {
        double d;
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = d = FastMath.tan(dArray[n]);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order + 2];
            dArray4[1] = 1.0;
            double d2 = d * d;
            for (int i = 1; i <= this.order; ++i) {
                double d3 = 0.0;
                dArray4[i + 1] = (double)i * dArray4[i];
                for (int j = i + 1; j >= 0; j -= 2) {
                    d3 = d3 * d2 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] + (double)(j - 3) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d3 *= d;
                }
                dArray3[i] = d3;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void acos(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d = dArray[n];
        dArray3[0] = FastMath.acos(d);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            dArray4[0] = -1.0;
            double d2 = d * d;
            double d3 = 1.0 / (1.0 - d2);
            double d4 = FastMath.sqrt(d3);
            dArray3[1] = d4 * dArray4[0];
            for (int i = 2; i <= this.order; ++i) {
                double d5 = 0.0;
                dArray4[i - 1] = (double)(i - 1) * dArray4[i - 2];
                for (int j = i - 1; j >= 0; j -= 2) {
                    d5 = d5 * d2 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] + (double)(2 * i - j) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d5 *= d;
                }
                dArray3[i] = (d4 *= d3) * d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void asin(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d = dArray[n];
        dArray3[0] = FastMath.asin(d);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            dArray4[0] = 1.0;
            double d2 = d * d;
            double d3 = 1.0 / (1.0 - d2);
            double d4 = FastMath.sqrt(d3);
            dArray3[1] = d4 * dArray4[0];
            for (int i = 2; i <= this.order; ++i) {
                double d5 = 0.0;
                dArray4[i - 1] = (double)(i - 1) * dArray4[i - 2];
                for (int j = i - 1; j >= 0; j -= 2) {
                    d5 = d5 * d2 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] + (double)(2 * i - j) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d5 *= d;
                }
                dArray3[i] = (d4 *= d3) * d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void atan(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d = dArray[n];
        dArray3[0] = FastMath.atan(d);
        if (this.order > 0) {
            double d2;
            double[] dArray4 = new double[this.order];
            dArray4[0] = 1.0;
            double d3 = d * d;
            double d4 = d2 = 1.0 / (1.0 + d3);
            dArray3[1] = d4 * dArray4[0];
            for (int i = 2; i <= this.order; ++i) {
                double d5 = 0.0;
                dArray4[i - 1] = (double)(-i) * dArray4[i - 2];
                for (int j = i - 1; j >= 0; j -= 2) {
                    d5 = d5 * d3 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] + (double)(j - 1 - 2 * i) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d5 *= d;
                }
                dArray3[i] = (d4 *= d2) * d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void atan2(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = new double[this.getSize()];
        this.multiply(dArray2, n2, dArray2, n2, dArray4, 0);
        double[] dArray5 = new double[this.getSize()];
        this.multiply(dArray, n, dArray, n, dArray5, 0);
        this.add(dArray4, 0, dArray5, 0, dArray5, 0);
        this.rootN(dArray5, 0, 2, dArray4, 0);
        if (dArray2[n2] >= 0.0) {
            this.add(dArray4, 0, dArray2, n2, dArray5, 0);
            this.divide(dArray, n, dArray5, 0, dArray4, 0);
            this.atan(dArray4, 0, dArray5, 0);
            for (int i = 0; i < dArray5.length; ++i) {
                dArray3[n3 + i] = 2.0 * dArray5[i];
            }
        } else {
            this.subtract(dArray4, 0, dArray2, n2, dArray5, 0);
            this.divide(dArray, n, dArray5, 0, dArray4, 0);
            this.atan(dArray4, 0, dArray5, 0);
            dArray3[n3] = (dArray5[0] <= 0.0 ? -Math.PI : Math.PI) - 2.0 * dArray5[0];
            for (int i = 1; i < dArray5.length; ++i) {
                dArray3[n3 + i] = -2.0 * dArray5[i];
            }
        }
        dArray3[n3] = FastMath.atan2(dArray[n], dArray2[n2]);
    }

    public void cosh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.cosh(dArray[n]);
        if (this.order > 0) {
            dArray3[1] = FastMath.sinh(dArray[n]);
            for (int i = 2; i <= this.order; ++i) {
                dArray3[i] = dArray3[i - 2];
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void sinh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = FastMath.sinh(dArray[n]);
        if (this.order > 0) {
            dArray3[1] = FastMath.cosh(dArray[n]);
            for (int i = 2; i <= this.order; ++i) {
                dArray3[i] = dArray3[i - 2];
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void tanh(double[] dArray, int n, double[] dArray2, int n2) {
        double d;
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = d = FastMath.tanh(dArray[n]);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order + 2];
            dArray4[1] = 1.0;
            double d2 = d * d;
            for (int i = 1; i <= this.order; ++i) {
                double d3 = 0.0;
                dArray4[i + 1] = (double)(-i) * dArray4[i];
                for (int j = i + 1; j >= 0; j -= 2) {
                    d3 = d3 * d2 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] - (double)(j - 3) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d3 *= d;
                }
                dArray3[i] = d3;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void acosh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d = dArray[n];
        dArray3[0] = FastMath.acosh(d);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            dArray4[0] = 1.0;
            double d2 = d * d;
            double d3 = 1.0 / (d2 - 1.0);
            double d4 = FastMath.sqrt(d3);
            dArray3[1] = d4 * dArray4[0];
            for (int i = 2; i <= this.order; ++i) {
                double d5 = 0.0;
                dArray4[i - 1] = (double)(1 - i) * dArray4[i - 2];
                for (int j = i - 1; j >= 0; j -= 2) {
                    d5 = d5 * d2 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(1 - j) * dArray4[j - 1] + (double)(j - 2 * i) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = -dArray4[1];
                }
                if ((i & 1) == 0) {
                    d5 *= d;
                }
                dArray3[i] = (d4 *= d3) * d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void asinh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d = dArray[n];
        dArray3[0] = FastMath.asinh(d);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            dArray4[0] = 1.0;
            double d2 = d * d;
            double d3 = 1.0 / (1.0 + d2);
            double d4 = FastMath.sqrt(d3);
            dArray3[1] = d4 * dArray4[0];
            for (int i = 2; i <= this.order; ++i) {
                double d5 = 0.0;
                dArray4[i - 1] = (double)(1 - i) * dArray4[i - 2];
                for (int j = i - 1; j >= 0; j -= 2) {
                    d5 = d5 * d2 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] + (double)(j - 2 * i) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d5 *= d;
                }
                dArray3[i] = (d4 *= d3) * d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void atanh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d = dArray[n];
        dArray3[0] = FastMath.atanh(d);
        if (this.order > 0) {
            double d2;
            double[] dArray4 = new double[this.order];
            dArray4[0] = 1.0;
            double d3 = d * d;
            double d4 = d2 = 1.0 / (1.0 - d3);
            dArray3[1] = d4 * dArray4[0];
            for (int i = 2; i <= this.order; ++i) {
                double d5 = 0.0;
                dArray4[i - 1] = (double)i * dArray4[i - 2];
                for (int j = i - 1; j >= 0; j -= 2) {
                    d5 = d5 * d3 + dArray4[j];
                    if (j > 2) {
                        dArray4[j - 2] = (double)(j - 1) * dArray4[j - 1] + (double)(2 * i - j + 1) * dArray4[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray4[0] = dArray4[1];
                }
                if ((i & 1) == 0) {
                    d5 *= d;
                }
                dArray3[i] = (d4 *= d2) * d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void compose(double[] dArray, int n, double[] dArray2, double[] dArray3, int n2) {
        for (int i = 0; i < this.compIndirection.length; ++i) {
            int[][] nArray = this.compIndirection[i];
            double d = 0.0;
            for (int j = 0; j < nArray.length; ++j) {
                int[] nArray2 = nArray[j];
                double d2 = (double)nArray2[0] * dArray2[nArray2[1]];
                for (int k = 2; k < nArray2.length; ++k) {
                    d2 *= dArray[n + nArray2[k]];
                }
                d += d2;
            }
            dArray3[n2 + i] = d;
        }
    }

    public double taylor(double[] dArray, int n, double ... dArray2) throws MathArithmeticException {
        double d = 0.0;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            int[] nArray = this.getPartialDerivativeOrders(i);
            double d2 = dArray[n + i];
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] <= 0) continue;
                try {
                    d2 *= FastMath.pow(dArray2[j], nArray[j]) / FACTORIAL.value(nArray[j]);
                    continue;
                }
                catch (NotPositiveException notPositiveException) {
                    throw new MathInternalError(notPositiveException);
                }
            }
            d += d2;
        }
        return d;
    }

    public void checkCompatibility(DSCompiler dSCompiler) throws DimensionMismatchException {
        if (this.parameters != dSCompiler.parameters) {
            throw new DimensionMismatchException(this.parameters, dSCompiler.parameters);
        }
        if (this.order != dSCompiler.order) {
            throw new DimensionMismatchException(this.order, dSCompiler.order);
        }
    }
}

