/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.Pair;

public class GaussIntegrator {
    private final double[] points;
    private final double[] weights;

    public GaussIntegrator(double[] dArray, double[] dArray2) throws NonMonotonicSequenceException, DimensionMismatchException {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        MathArrays.checkOrder(dArray, MathArrays.OrderDirection.INCREASING, true, true);
        this.points = (double[])dArray.clone();
        this.weights = (double[])dArray2.clone();
    }

    public GaussIntegrator(Pair<double[], double[]> pair) throws NonMonotonicSequenceException {
        this(pair.getFirst(), pair.getSecond());
    }

    public double integrate(UnivariateFunction univariateFunction) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.points.length; ++i) {
            double d3 = this.points[i];
            double d4 = this.weights[i];
            double d5 = d4 * univariateFunction.value(d3) - d2;
            double d6 = d + d5;
            d2 = d6 - d - d5;
            d = d6;
        }
        return d;
    }

    public int getNumberOfPoints() {
        return this.points.length;
    }

    public double getPoint(int n) {
        return this.points[n];
    }

    public double getWeight(int n) {
        return this.weights[n];
    }
}

