/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;

public class LinearInterpolator
implements UnivariateInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 2, true);
        }
        int n = dArray.length - 1;
        MathArrays.checkOrder(dArray);
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = (dArray2[i + 1] - dArray2[i]) / (dArray[i + 1] - dArray[i]);
        }
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n];
        double[] dArray4 = new double[2];
        for (int i = 0; i < n; ++i) {
            dArray4[0] = dArray2[i];
            dArray4[1] = dArray3[i];
            polynomialFunctionArray[i] = new PolynomialFunction(dArray4);
        }
        return new PolynomialSplineFunction(dArray, polynomialFunctionArray);
    }
}

