/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math4.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math4.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class LoessInterpolator
implements UnivariateInterpolator,
Serializable {
    public static final double DEFAULT_BANDWIDTH = 0.3;
    public static final int DEFAULT_ROBUSTNESS_ITERS = 2;
    public static final double DEFAULT_ACCURACY = 1.0E-12;
    private static final long serialVersionUID = 5204927143605193821L;
    private final double bandwidth;
    private final int robustnessIters;
    private final double accuracy;

    public LoessInterpolator() {
        this.bandwidth = 0.3;
        this.robustnessIters = 2;
        this.accuracy = 1.0E-12;
    }

    public LoessInterpolator(double d, int n) {
        this(d, n, 1.0E-12);
    }

    public LoessInterpolator(double d, int n, double d2) throws OutOfRangeException, NotPositiveException {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.BANDWIDTH, (Number)d, 0, 1);
        }
        this.bandwidth = d;
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.ROBUSTNESS_ITERATIONS, n);
        }
        this.robustnessIters = n;
        this.accuracy = d2;
    }

    @Override
    public final PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) throws NonMonotonicSequenceException, DimensionMismatchException, NoDataException, NotFiniteNumberException, NumberIsTooSmallException {
        return new SplineInterpolator().interpolate(dArray, this.smooth(dArray, dArray2));
    }

    public final double[] smooth(double[] dArray, double[] dArray2, double[] dArray3) throws NonMonotonicSequenceException, DimensionMismatchException, NoDataException, NotFiniteNumberException, NumberIsTooSmallException {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        int n = dArray.length;
        if (n == 0) {
            throw new NoDataException();
        }
        LoessInterpolator.checkAllFiniteReal(dArray);
        LoessInterpolator.checkAllFiniteReal(dArray2);
        LoessInterpolator.checkAllFiniteReal(dArray3);
        MathArrays.checkOrder(dArray);
        if (n == 1) {
            return new double[]{dArray2[0]};
        }
        if (n == 2) {
            return new double[]{dArray2[0], dArray2[1]};
        }
        int n2 = (int)(this.bandwidth * (double)n);
        if (n2 < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.BANDWIDTH, (Number)n2, 2, true);
        }
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        Arrays.fill(dArray7, 1.0);
        for (int i = 0; i <= this.robustnessIters; ++i) {
            int[] nArray = new int[]{0, n2 - 1};
            for (int j = 0; j < n; ++j) {
                int n3;
                int n4;
                double d = dArray[j];
                if (j > 0) {
                    LoessInterpolator.updateBandwidthInterval(dArray, dArray3, j, nArray);
                }
                int n5 = dArray[j] - dArray[n4 = nArray[0]] > dArray[n3 = nArray[1]] - dArray[j] ? n4 : n3;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = FastMath.abs(1.0 / (dArray[n5] - d));
                for (int k = n4; k <= n3; ++k) {
                    double d8 = dArray[k];
                    double d9 = dArray2[k];
                    double d10 = k < j ? d - d8 : d8 - d;
                    double d11 = LoessInterpolator.tricube(d10 * d7) * dArray7[k] * dArray3[k];
                    double d12 = d8 * d11;
                    d2 += d11;
                    d3 += d12;
                    d4 += d8 * d12;
                    d5 += d9 * d11;
                    d6 += d9 * d12;
                }
                double d13 = d3 / d2;
                double d14 = d5 / d2;
                double d15 = d6 / d2;
                double d16 = d4 / d2;
                double d17 = FastMath.sqrt(FastMath.abs(d16 - d13 * d13)) < this.accuracy ? 0.0 : (d15 - d13 * d14) / (d16 - d13 * d13);
                double d18 = d14 - d17 * d13;
                dArray4[j] = d17 * d + d18;
                dArray5[j] = FastMath.abs(dArray2[j] - dArray4[j]);
            }
            if (i == this.robustnessIters) break;
            System.arraycopy(dArray5, 0, dArray6, 0, n);
            Arrays.sort(dArray6);
            double d = dArray6[n / 2];
            if (FastMath.abs(d) < this.accuracy) break;
            for (int j = 0; j < n; ++j) {
                double d19 = dArray5[j] / (6.0 * d);
                if (d19 >= 1.0) {
                    dArray7[j] = 0.0;
                    continue;
                }
                double d20 = 1.0 - d19 * d19;
                dArray7[j] = d20 * d20;
            }
        }
        return dArray4;
    }

    public final double[] smooth(double[] dArray, double[] dArray2) throws NonMonotonicSequenceException, DimensionMismatchException, NoDataException, NotFiniteNumberException, NumberIsTooSmallException {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        double[] dArray3 = new double[dArray.length];
        Arrays.fill(dArray3, 1.0);
        return this.smooth(dArray, dArray2, dArray3);
    }

    private static void updateBandwidthInterval(double[] dArray, double[] dArray2, int n, int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = LoessInterpolator.nextNonzero(dArray2, n3);
        if (n4 < dArray.length && dArray[n4] - dArray[n] < dArray[n] - dArray[n2]) {
            int n5;
            nArray[0] = n5 = LoessInterpolator.nextNonzero(dArray2, nArray[0]);
            nArray[1] = n4;
        }
    }

    private static int nextNonzero(double[] dArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < dArray.length && dArray[n2] == 0.0; ++n2) {
        }
        return n2;
    }

    private static double tricube(double d) {
        double d2 = FastMath.abs(d);
        if (d2 >= 1.0) {
            return 0.0;
        }
        double d3 = 1.0 - d2 * d2 * d2;
        return d3 * d3 * d3;
    }

    private static void checkAllFiniteReal(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            MathUtils.checkFinite(dArray[i]);
        }
    }
}

