/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.MultivariateFunction;
import org.apache.commons.math4.analysis.interpolation.InterpolatingMicrosphere;
import org.apache.commons.math4.analysis.interpolation.MultivariateInterpolator;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.rng.sampling.UnitSphereSampler;
import org.apache.commons.rng.simple.RandomSource;

public class MicrosphereProjectionInterpolator
implements MultivariateInterpolator {
    private final double exponent;
    private final InterpolatingMicrosphere microsphere;
    private final boolean sharedSphere;
    private final double noInterpolationTolerance;

    public MicrosphereProjectionInterpolator(int n, int n2, double d, double d2, double d3, double d4, boolean bl, double d5) {
        this(new InterpolatingMicrosphere(n, n2, d, d2, d3, new UnitSphereSampler(n, RandomSource.create(RandomSource.MT_64))), d4, bl, d5);
    }

    public MicrosphereProjectionInterpolator(InterpolatingMicrosphere interpolatingMicrosphere, double d, boolean bl, double d2) throws NotPositiveException {
        if (d < 0.0) {
            throw new NotPositiveException(d);
        }
        this.microsphere = interpolatingMicrosphere;
        this.exponent = d;
        this.sharedSphere = bl;
        this.noInterpolationTolerance = d2;
    }

    @Override
    public MultivariateFunction interpolate(final double[][] dArray, final double[] dArray2) throws DimensionMismatchException, NoDataException, NullArgumentException {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray[0] == null) {
            throw new NullArgumentException();
        }
        int n = this.microsphere.getDimension();
        if (n != dArray[0].length) {
            throw new DimensionMismatchException(dArray[0].length, n);
        }
        final InterpolatingMicrosphere interpolatingMicrosphere = this.sharedSphere ? this.microsphere : this.microsphere.copy();
        return new MultivariateFunction(){

            @Override
            public double value(double[] dArray3) {
                return interpolatingMicrosphere.value(dArray3, dArray, dArray2, MicrosphereProjectionInterpolator.this.exponent, MicrosphereProjectionInterpolator.this.noInterpolationTolerance);
            }
        };
    }
}

