/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.linear.DecompositionSolver;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.QRDecomposition;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.FastMath;

public class RRQRDecomposition
extends QRDecomposition {
    private int[] p;
    private RealMatrix cachedP;

    public RRQRDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 0.0);
    }

    public RRQRDecomposition(RealMatrix realMatrix, double d) {
        super(realMatrix, d);
    }

    @Override
    protected void decompose(double[][] dArray) {
        this.p = new int[dArray.length];
        for (int i = 0; i < this.p.length; ++i) {
            this.p[i] = i;
        }
        super.decompose(dArray);
    }

    @Override
    protected void performHouseholderReflection(int n, double[][] dArray) {
        double d = 0.0;
        int n2 = n;
        for (int i = n; i < dArray.length; ++i) {
            double d2 = 0.0;
            for (int j = n; j < dArray[i].length; ++j) {
                d2 += dArray[i][j] * dArray[i][j];
            }
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        if (n2 != n) {
            double[] dArray2 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = dArray2;
            int n3 = this.p[n];
            this.p[n] = this.p[n2];
            this.p[n2] = n3;
        }
        super.performHouseholderReflection(n, dArray);
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int n = this.p.length;
            this.cachedP = MatrixUtils.createRealMatrix(n, n);
            for (int i = 0; i < n; ++i) {
                this.cachedP.setEntry(this.p[i], i, 1.0);
            }
        }
        return this.cachedP;
    }

    public int getRank(double d) {
        double d2;
        int n;
        double d3;
        RealMatrix realMatrix = this.getR();
        int n2 = realMatrix.getRowDimension();
        int n3 = realMatrix.getColumnDimension();
        double d4 = d3 = realMatrix.getFrobeniusNorm();
        for (n = 1; n < FastMath.min(n2, n3) && (d2 = realMatrix.getSubMatrix(n, n2 - 1, n, n3 - 1).getFrobeniusNorm()) != 0.0 && !(d2 / d3 * d4 < d); ++n) {
            d3 = d2;
        }
        return n;
    }

    @Override
    public DecompositionSolver getSolver() {
        return new Solver(super.getSolver(), this.getP());
    }

    private static class Solver
    implements DecompositionSolver {
        private final DecompositionSolver upper;
        private RealMatrix p;

        private Solver(DecompositionSolver decompositionSolver, RealMatrix realMatrix) {
            this.upper = decompositionSolver;
            this.p = realMatrix;
        }

        @Override
        public boolean isNonSingular() {
            return this.upper.isNonSingular();
        }

        @Override
        public RealVector solve(RealVector realVector) {
            return this.p.operate(this.upper.solve(realVector));
        }

        @Override
        public RealMatrix solve(RealMatrix realMatrix) {
            return this.p.multiply(this.upper.solve(realMatrix));
        }

        @Override
        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.p.getRowDimension()));
        }
    }
}

