/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math4.exception.MathParseException;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.CompositeFormat;

public class RealMatrixFormat {
    private static final String DEFAULT_PREFIX = "{";
    private static final String DEFAULT_SUFFIX = "}";
    private static final String DEFAULT_ROW_PREFIX = "{";
    private static final String DEFAULT_ROW_SUFFIX = "}";
    private static final String DEFAULT_ROW_SEPARATOR = ",";
    private static final String DEFAULT_COLUMN_SEPARATOR = ",";
    private final String prefix;
    private final String suffix;
    private final String rowPrefix;
    private final String rowSuffix;
    private final String rowSeparator;
    private final String columnSeparator;
    private final NumberFormat format;

    public RealMatrixFormat() {
        this("{", "}", "{", "}", ",", ",", CompositeFormat.getDefaultNumberFormat());
    }

    public RealMatrixFormat(NumberFormat numberFormat) {
        this("{", "}", "{", "}", ",", ",", numberFormat);
    }

    public RealMatrixFormat(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, CompositeFormat.getDefaultNumberFormat());
    }

    public RealMatrixFormat(String string, String string2, String string3, String string4, String string5, String string6, NumberFormat numberFormat) {
        this.prefix = string;
        this.suffix = string2;
        this.rowPrefix = string3;
        this.rowSuffix = string4;
        this.rowSeparator = string5;
        this.columnSeparator = string6;
        this.format = numberFormat;
        this.format.setGroupingUsed(false);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRowPrefix() {
        return this.rowPrefix;
    }

    public String getRowSuffix() {
        return this.rowSuffix;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public static RealMatrixFormat getInstance() {
        return RealMatrixFormat.getInstance(Locale.getDefault());
    }

    public static RealMatrixFormat getInstance(Locale locale) {
        return new RealMatrixFormat(CompositeFormat.getDefaultNumberFormat(locale));
    }

    public String format(RealMatrix realMatrix) {
        return this.format(realMatrix, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(RealMatrix realMatrix, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        stringBuffer.append(this.prefix);
        int n = realMatrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.rowPrefix);
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                if (j > 0) {
                    stringBuffer.append(this.columnSeparator);
                }
                CompositeFormat.formatDouble(realMatrix.getEntry(i, j), this.format, stringBuffer, fieldPosition);
            }
            stringBuffer.append(this.rowSuffix);
            if (i >= n - 1) continue;
            stringBuffer.append(this.rowSeparator);
        }
        stringBuffer.append(this.suffix);
        return stringBuffer;
    }

    public RealMatrix parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        RealMatrix realMatrix = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Array2DRowRealMatrix.class);
        }
        return realMatrix;
    }

    public RealMatrix parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        String string2 = this.prefix.trim();
        String string3 = this.suffix.trim();
        String string4 = this.rowPrefix.trim();
        String string5 = this.rowSuffix.trim();
        String string6 = this.columnSeparator.trim();
        String string7 = this.rowSeparator.trim();
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        if (!CompositeFormat.parseFixedstring(string, string2, parsePosition)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Number> arrayList2 = new ArrayList<Number>();
        boolean bl = true;
        while (bl) {
            if (!arrayList2.isEmpty()) {
                CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
                if (!CompositeFormat.parseFixedstring(string, string6, parsePosition)) {
                    if (string5.length() != 0 && !CompositeFormat.parseFixedstring(string, string5, parsePosition)) {
                        return null;
                    }
                    CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
                    if (CompositeFormat.parseFixedstring(string, string7, parsePosition)) {
                        arrayList.add(arrayList2);
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    bl = false;
                }
            } else {
                CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
                if (string4.length() != 0 && !CompositeFormat.parseFixedstring(string, string4, parsePosition)) {
                    return null;
                }
            }
            if (!bl) continue;
            CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
            Number number = CompositeFormat.parseNumber(string, this.format, parsePosition);
            if (number != null) {
                arrayList2.add(number);
                continue;
            }
            if (arrayList2.isEmpty()) {
                bl = false;
                continue;
            }
            parsePosition.setIndex(n);
            return null;
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(arrayList2);
        }
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        if (!CompositeFormat.parseFixedstring(string, string3, parsePosition)) {
            return null;
        }
        if (arrayList.isEmpty()) {
            parsePosition.setIndex(n);
            return null;
        }
        double[][] dArrayArray = new double[arrayList.size()][];
        int n2 = 0;
        for (List list : arrayList) {
            dArrayArray[n2] = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                dArrayArray[n2][i] = ((Number)list.get(i)).doubleValue();
            }
            ++n2;
        }
        return MatrixUtils.createRealMatrix(dArrayArray);
    }
}

