/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class BinomialCoefficient {
    public static long value(int n, int n2) {
        BinomialCoefficient.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 1L;
        }
        if (n2 == 1 || n2 == n - 1) {
            return n;
        }
        if (n2 > n / 2) {
            return BinomialCoefficient.value(n, n - n2);
        }
        long l = 1L;
        if (n <= 61) {
            int n3 = n - n2 + 1;
            for (int i = 1; i <= n2; ++i) {
                l = l * (long)n3 / (long)i;
                ++n3;
            }
        } else if (n <= 66) {
            int n4 = n - n2 + 1;
            for (int i = 1; i <= n2; ++i) {
                long l2 = ArithmeticUtils.gcd(n4, i);
                l = l / ((long)i / l2) * ((long)n4 / l2);
                ++n4;
            }
        } else {
            int n5 = n - n2 + 1;
            for (int i = 1; i <= n2; ++i) {
                long l3 = ArithmeticUtils.gcd(n5, i);
                l = ArithmeticUtils.mulAndCheck(l / ((long)i / l3), (long)n5 / l3);
                ++n5;
            }
        }
        return l;
    }

    static void checkBinomial(int n, int n2) {
        if (n < 0) {
            throw new CombinatoricsException("Number {0} is negative", n);
        }
        if (n2 > n || n2 < 0) {
            throw new CombinatoricsException("Number {0} is out of range [{1}, {2}]", n2, 0, n);
        }
    }
}

