/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.numbers.fraction.AbstractFormat;
import org.apache.commons.numbers.fraction.Fraction;
import org.apache.commons.numbers.fraction.FractionParseException;
import org.apache.commons.numbers.fraction.ProperFractionFormat;

public class FractionFormat
extends AbstractFormat {
    private static final long serialVersionUID = 3008655719530972612L;

    public FractionFormat() {
    }

    public FractionFormat(NumberFormat numberFormat) {
        super(numberFormat);
    }

    public FractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        super(numberFormat, numberFormat2);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static String formatFraction(Fraction fraction) {
        return FractionFormat.getImproperInstance().format(fraction);
    }

    public static FractionFormat getImproperInstance() {
        return FractionFormat.getImproperInstance(Locale.getDefault());
    }

    public static FractionFormat getImproperInstance(Locale locale) {
        return new FractionFormat(FractionFormat.getDefaultNumberFormat(locale));
    }

    public static FractionFormat getProperInstance() {
        return FractionFormat.getProperInstance(Locale.getDefault());
    }

    public static FractionFormat getProperInstance(Locale locale) {
        return new ProperFractionFormat(FractionFormat.getDefaultNumberFormat(locale));
    }

    protected static NumberFormat getDefaultNumberFormat() {
        return FractionFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    public StringBuffer format(Fraction fraction, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        this.getNumeratorFormat().format(fraction.getNumerator(), stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(fraction.getDenominator(), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = null;
        if (object instanceof Fraction) {
            stringBuffer2 = this.format((Fraction)object, stringBuffer, fieldPosition);
        } else if (object instanceof Number) {
            stringBuffer2 = this.format(new Fraction(((Number)object).doubleValue()), stringBuffer, fieldPosition);
        } else {
            throw new IllegalArgumentException("cannot format given object as a fraction number");
        }
        return stringBuffer2;
    }

    @Override
    public Fraction parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Fraction fraction = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new FractionParseException(string, parsePosition.getErrorIndex(), Fraction.class);
        }
        return fraction;
    }

    @Override
    public Fraction parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        FractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number = this.getNumeratorFormat().parse(string, parsePosition);
        if (number == null) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c = FractionFormat.parseNextCharacter(string, parsePosition);
        switch (c) {
            case '\u0000': {
                return new Fraction(number.intValue(), 1);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        FractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number2 = this.getDenominatorFormat().parse(string, parsePosition);
        if (number2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        return new Fraction(number.intValue(), number2.intValue());
    }
}

