/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

public class Digamma {
    private static final double GAMMA = 0.5772156649015329;
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;
    private static final double F_M1_12 = -0.08333333333333333;
    private static final double F_1_120 = 0.008333333333333333;
    private static final double F_M1_252 = -0.003968253968253968;

    public static double value(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        double d2 = 0.0;
        if (d < 0.0) {
            d2 -= Math.PI / Math.tan(Math.PI * d);
            d = 1.0 - d;
        }
        if (d > 0.0 && d <= 1.0E-5) {
            return d2 - 0.5772156649015329 - 1.0 / d;
        }
        while (d < 49.0) {
            d2 -= 1.0 / d;
            d += 1.0;
        }
        double d3 = 1.0 / (d * d);
        return d2 += Math.log(d) - 0.5 / d + d3 * (-0.08333333333333333 + d3 * (0.008333333333333333 + -0.003968253968253968 * d3));
    }
}

