/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.LanczosApproximation;
import org.apache.commons.numbers.gamma.LogGamma1p;

public class LogGamma {
    private static final double LANCZOS_G = 4.7421875;
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);

    public static double value(double d) {
        if (Double.isNaN(d) || d <= 0.0) {
            return Double.NaN;
        }
        if (d < 0.5) {
            return LogGamma1p.value(d) - Math.log(d);
        }
        if (d <= 2.5) {
            return LogGamma1p.value(d - 0.5 - 0.5);
        }
        if (d <= 8.0) {
            int n = (int)Math.floor(d - 1.5);
            double d2 = 1.0;
            for (int i = 1; i <= n; ++i) {
                d2 *= d - (double)i;
            }
            return LogGamma1p.value(d - (double)(n + 1)) + Math.log(d2);
        }
        double d3 = LanczosApproximation.value(d);
        double d4 = d + 4.7421875 + 0.5;
        return (d + 0.5) * Math.log(d4) - d4 + HALF_LOG_2_PI + Math.log(d3 / d);
    }
}

