/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class BoxMullerNormalizedGaussianSampler
implements NormalizedGaussianSampler {
    private double nextGaussian = Double.NaN;
    private final UniformRandomProvider rng;

    public BoxMullerNormalizedGaussianSampler(UniformRandomProvider uniformRandomProvider) {
        this.rng = uniformRandomProvider;
    }

    @Override
    public double sample() {
        double d;
        if (Double.isNaN(this.nextGaussian)) {
            double d2 = this.rng.nextDouble();
            double d3 = this.rng.nextDouble();
            double d4 = Math.PI * 2 * d2;
            double d5 = Math.sqrt(-2.0 * Math.log(d3));
            d = d5 * Math.cos(d4);
            this.nextGaussian = d5 * Math.sin(d4);
        } else {
            d = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return d;
    }

    public String toString() {
        return "Box-Muller normalized Gaussian deviate [" + this.rng.toString() + "]";
    }
}

