/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

class InternalGamma {
    public static final double LANCZOS_G = 4.7421875;
    private static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);

    private InternalGamma() {
    }

    public static double logGamma(double d) {
        double d2 = InternalGamma.lanczos(d);
        double d3 = d + 4.7421875 + 0.5;
        return (d + 0.5) * Math.log(d3) - d3 + HALF_LOG_2_PI + Math.log(d2 / d);
    }

    private static double lanczos(double d) {
        double d2 = 0.0;
        for (int i = LANCZOS.length - 1; i > 0; --i) {
            d2 += LANCZOS[i] / (d + (double)i);
        }
        return d2 + LANCZOS[0];
    }
}

