/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import io.virtdata.annotations.Category;
import io.virtdata.processors.DocForFunc;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class FuncEnumerator {
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private DocForFunc model;
    private List<Listener> listeners = new ArrayList<Listener>();
    private String anchorPackage;
    private String anchorSimpleName;

    public FuncEnumerator(Types types, Elements elements, Filer filer) {
        this.types = types;
        this.elements = elements;
        this.filer = filer;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void onClass(String string, String string2, String string3) {
        if (this.model != null) {
            throw new RuntimeException("The DocModel was overwritten. Perhaps you are not calling flush() ?");
        }
        this.model = new DocForFunc();
        this.model.setPackageName(string);
        this.model.setClassName(string2);
        this.model.setClassJavadoc(string3);
    }

    public void onApplyTypes(String string, String string2) {
        this.model.setInType(string);
        this.model.setOutType(string2);
    }

    public void onConstructor(LinkedHashMap<String, String> linkedHashMap, String string, List<List<String>> list) {
        this.model.addCtor(string, linkedHashMap, list);
    }

    public void flush() {
        this.listeners.forEach(listener -> listener.onFunctionModel(this.model));
        this.model = null;
    }

    public void onCategories(Category[] categoryArray) {
        this.model.addCategories(categoryArray);
    }

    public static interface Listener {
        public void onFunctionModel(DocForFunc var1);
    }
}

