/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.WeightedEvaluation;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.SecondMoment;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = 20150412L;
    protected SecondMoment moment = null;
    protected boolean incMoment = true;
    private boolean isBiasCorrected = true;

    public Variance() {
        this.moment = new SecondMoment();
    }

    public Variance(SecondMoment secondMoment) {
        this.incMoment = false;
        this.moment = secondMoment;
    }

    public Variance(boolean bl) {
        this.moment = new SecondMoment();
        this.isBiasCorrected = bl;
    }

    public Variance(boolean bl, SecondMoment secondMoment) {
        this.incMoment = false;
        this.moment = secondMoment;
        this.isBiasCorrected = bl;
    }

    public Variance(Variance variance) throws NullArgumentException {
        Variance.copy(variance, this);
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double evaluate(double[] dArray) throws MathIllegalArgumentException {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(dArray, 0, dArray.length);
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2)) {
            if (n2 == 1) {
                d = 0.0;
            } else if (n2 > 1) {
                Mean mean = new Mean();
                double d2 = mean.evaluate(dArray, n, n2);
                d = this.evaluate(dArray, d2, n, n2);
            }
        }
        return d;
    }

    @Override
    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, dArray2, n, n2)) {
            if (n2 == 1) {
                d = 0.0;
            } else if (n2 > 1) {
                Mean mean = new Mean();
                double d2 = mean.evaluate(dArray, dArray2, n, n2);
                d = this.evaluate(dArray, dArray2, d2, n, n2);
            }
        }
        return d;
    }

    @Override
    public double evaluate(double[] dArray, double[] dArray2) throws MathIllegalArgumentException {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d, int n, int n2) throws MathIllegalArgumentException {
        double d2 = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2)) {
            if (n2 == 1) {
                d2 = 0.0;
            } else if (n2 > 1) {
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                for (int i = n; i < n + n2; ++i) {
                    d4 = dArray[i] - d;
                    d3 += d4 * d4;
                    d5 += d4;
                }
                double d6 = n2;
                d2 = this.isBiasCorrected ? (d3 - d5 * d5 / d6) / (d6 - 1.0) : (d3 - d5 * d5 / d6) / d6;
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double d) throws MathIllegalArgumentException {
        return this.evaluate(dArray, d, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double[] dArray2, double d, int n, int n2) throws MathIllegalArgumentException {
        double d2 = Double.NaN;
        if (MathArrays.verifyValues(dArray, dArray2, n, n2)) {
            if (n2 == 1) {
                d2 = 0.0;
            } else if (n2 > 1) {
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                for (int i = n; i < n + n2; ++i) {
                    d4 = dArray[i] - d;
                    d3 += dArray2[i] * (d4 * d4);
                    d5 += dArray2[i] * d4;
                }
                double d6 = 0.0;
                for (int i = n; i < n + n2; ++i) {
                    d6 += dArray2[i];
                }
                d2 = this.isBiasCorrected ? (d3 - d5 * d5 / d6) / (d6 - 1.0) : (d3 - d5 * d5 / d6) / d6;
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double[] dArray2, double d) throws MathIllegalArgumentException {
        return this.evaluate(dArray, dArray2, d, 0, dArray.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public void setBiasCorrected(boolean bl) {
        this.isBiasCorrected = bl;
    }

    @Override
    public Variance copy() {
        Variance variance = new Variance();
        Variance.copy(this, variance);
        return variance;
    }

    public static void copy(Variance variance, Variance variance2) throws NullArgumentException {
        MathUtils.checkNotNull(variance);
        MathUtils.checkNotNull(variance2);
        variance2.moment = variance.moment.copy();
        variance2.isBiasCorrected = variance.isBiasCorrected;
        variance2.incMoment = variance.incMoment;
    }
}

