/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.summary;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.WeightedEvaluation;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Product
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public Product() {
        this.n = 0L;
        this.value = 1.0;
    }

    public Product(Product product) throws NullArgumentException {
        Product.copy(product, this);
    }

    @Override
    public void increment(double d) {
        this.value *= d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 1.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2, true)) {
            d = 1.0;
            for (int i = n; i < n + n2; ++i) {
                d *= dArray[i];
            }
        }
        return d;
    }

    @Override
    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, dArray2, n, n2, true)) {
            d = 1.0;
            for (int i = n; i < n + n2; ++i) {
                d *= FastMath.pow(dArray[i], dArray2[i]);
            }
        }
        return d;
    }

    @Override
    public double evaluate(double[] dArray, double[] dArray2) throws MathIllegalArgumentException {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    @Override
    public Product copy() {
        Product product = new Product();
        Product.copy(this, product);
        return product;
    }

    public static void copy(Product product, Product product2) throws NullArgumentException {
        MathUtils.checkNotNull(product);
        MathUtils.checkNotNull(product2);
        product2.n = product.n;
        product2.value = product.value;
    }
}

