/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import io.virtdata.shaded.oac.statistics.distribution.SaddlePointExpansion;

public class HypergeometricDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfSuccesses;
    private final int populationSize;
    private final int sampleSize;

    public HypergeometricDistribution(int n, int n2, int n3) {
        if (n <= 0) {
            throw new DistributionException("Number {0} is negative", n);
        }
        if (n2 < 0) {
            throw new DistributionException("Number {0} is negative", n2);
        }
        if (n3 < 0) {
            throw new DistributionException("Number {0} is negative", n3);
        }
        if (n2 > n) {
            throw new DistributionException("{0} > {1}", n2, n);
        }
        if (n3 > n) {
            throw new DistributionException("{0} > {1}", n3, n);
        }
        this.numberOfSuccesses = n2;
        this.populationSize = n;
        this.sampleSize = n3;
    }

    @Override
    public double cumulativeProbability(int n) {
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double d = n < nArray[0] ? 0.0 : (n >= nArray[1] ? 1.0 : this.innerCumulativeProbability(nArray[0], n, 1));
        return d;
    }

    private int[] getDomain(int n, int n2, int n3) {
        return new int[]{this.getLowerDomain(n, n2, n3), this.getUpperDomain(n2, n3)};
    }

    private int getLowerDomain(int n, int n2, int n3) {
        return Math.max(0, n2 - (n - n3));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int n, int n2) {
        return Math.min(n2, n);
    }

    @Override
    public double probability(int n) {
        double d = this.logProbability(n);
        return d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d);
    }

    @Override
    public double logProbability(int n) {
        double d;
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        if (n < nArray[0] || n > nArray[1]) {
            d = Double.NEGATIVE_INFINITY;
        } else {
            double d2 = (double)this.sampleSize / (double)this.populationSize;
            double d3 = (double)(this.populationSize - this.sampleSize) / (double)this.populationSize;
            double d4 = SaddlePointExpansion.logBinomialProbability(n, this.numberOfSuccesses, d2, d3);
            double d5 = SaddlePointExpansion.logBinomialProbability(this.sampleSize - n, this.populationSize - this.numberOfSuccesses, d2, d3);
            double d6 = SaddlePointExpansion.logBinomialProbability(this.sampleSize, this.populationSize, d2, d3);
            d = d4 + d5 - d6;
        }
        return d;
    }

    public double upperCumulativeProbability(int n) {
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double d = n <= nArray[0] ? 1.0 : (n > nArray[1] ? 0.0 : this.innerCumulativeProbability(nArray[1], n, -1));
        return d;
    }

    private double innerCumulativeProbability(int n, int n2, int n3) {
        double d = this.probability(n);
        while (n != n2) {
            d += this.probability(n += n3);
        }
        return d;
    }

    @Override
    public double getMean() {
        return (double)this.getSampleSize() * ((double)this.getNumberOfSuccesses() / (double)this.getPopulationSize());
    }

    @Override
    public double getVariance() {
        double d = this.getPopulationSize();
        double d2 = this.getNumberOfSuccesses();
        double d3 = this.getSampleSize();
        return d3 * d2 * (d - d3) * (d - d2) / (d * d * (d - 1.0));
    }

    @Override
    public int getSupportLowerBound() {
        return Math.max(0, this.getSampleSize() + this.getNumberOfSuccesses() - this.getPopulationSize());
    }

    @Override
    public int getSupportUpperBound() {
        return Math.min(this.getNumberOfSuccesses(), this.getSampleSize());
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

