/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;

public class ConfidenceInterval {
    private double lowerBound;
    private double upperBound;
    private double confidenceLevel;

    public ConfidenceInterval(double d, double d2, double d3) {
        this.checkParameters(d, d2, d3);
        this.lowerBound = d;
        this.upperBound = d2;
        this.confidenceLevel = d3;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public String toString() {
        return "[" + this.lowerBound + ";" + this.upperBound + "] (confidence level:" + this.confidenceLevel + ")";
    }

    private void checkParameters(double d, double d2, double d3) {
        if (d >= d2) {
            throw new MathIllegalArgumentException(LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, d, d2);
        }
        if (d3 <= 0.0 || d3 >= 1.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.OUT_OF_BOUNDS_CONFIDENCE_LEVEL, d3, 0, 1);
        }
    }
}

