/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import io.virtdata.api.ValuesArrayBinder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringMapCompositor
implements ValuesArrayBinder<StringMapCompositor, String> {
    private static Pattern tokenPattern = Pattern.compile("(?<section>(?<literal>[^{}]+)?(?<anchor>\\{(?<token>[a-zA-Z.-]+)?\\})?)");
    private String[] templateSegments;
    private int buffersize = 0;

    public StringMapCompositor(String string) {
        this.templateSegments = this.parseTemplate(string);
    }

    private String[] parseTemplate(String string) {
        Matcher matcher = tokenPattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group("literal");
            String string3 = matcher.group("anchor");
            String string4 = matcher.group("token");
            if (string3 == null && string2 == null) break;
            arrayList.add(Optional.ofNullable(string2).orElse(""));
            if (string3 == null) continue;
            arrayList.add(Optional.ofNullable(string4).orElse(String.valueOf(n++)));
        }
        if (arrayList.size() % 2 == 0) {
            arrayList.add("");
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String bindValues(StringMapCompositor stringMapCompositor, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder(this.buffersize);
        int n = objectArray.length;
        if (objectArray.length != this.templateSegments.length >> 1) {
            throw new RuntimeException("values array has " + objectArray.length + " elements, but  the template needs " + (this.templateSegments.length >> 1));
        }
        stringBuilder.append(this.templateSegments[0]);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(objectArray[i]);
            stringBuilder.append(this.templateSegments[2 * i + 2]);
        }
        if (stringBuilder.length() > this.buffersize) {
            this.buffersize = stringBuilder.length() + 5;
        }
        return stringBuilder.toString();
    }
}

