/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.function;

import org.apache.commons.math4.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;

public class HarmonicOscillator
implements UnivariateDifferentiableFunction {
    private final double amplitude;
    private final double omega;
    private final double phase;

    public HarmonicOscillator(double d, double d2, double d3) {
        this.amplitude = d;
        this.omega = d2;
        this.phase = d3;
    }

    @Override
    public double value(double d) {
        return HarmonicOscillator.value(this.omega * d + this.phase, this.amplitude);
    }

    private static double value(double d, double d2) {
        return d2 * FastMath.cos(d);
    }

    @Override
    public DerivativeStructure value(DerivativeStructure derivativeStructure) throws DimensionMismatchException {
        double d = derivativeStructure.getValue();
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double d2 = this.omega * d + this.phase;
        dArray[0] = this.amplitude * FastMath.cos(d2);
        if (dArray.length > 1) {
            dArray[1] = -this.amplitude * this.omega * FastMath.sin(d2);
            double d3 = -this.omega * this.omega;
            for (int i = 2; i < dArray.length; ++i) {
                dArray[i] = d3 * dArray[i - 2];
            }
        }
        return derivativeStructure.compose(dArray);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double d, double ... dArray) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(dArray);
            return HarmonicOscillator.value(d * dArray[1] + dArray[2], dArray[0]);
        }

        @Override
        public double[] gradient(double d, double ... dArray) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(dArray);
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = dArray[2];
            double d5 = d3 * d + d4;
            double d6 = HarmonicOscillator.value(d5, 1.0);
            double d7 = -d2 * FastMath.sin(d5);
            double d8 = d7 * d;
            return new double[]{d6, d8, d7};
        }

        private void validateParameters(double[] dArray) throws NullArgumentException, DimensionMismatchException {
            if (dArray == null) {
                throw new NullArgumentException();
            }
            if (dArray.length != 3) {
                throw new DimensionMismatchException(dArray.length, 3);
            }
        }
    }
}

