/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.fraction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.ZeroException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.fraction.BigFractionField;
import org.apache.commons.math4.fraction.FractionConversionException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class BigFraction
extends Number
implements FieldElement<BigFraction>,
Comparable<BigFraction>,
Serializable {
    public static final BigFraction TWO = new BigFraction(2);
    public static final BigFraction ONE = new BigFraction(1);
    public static final BigFraction ZERO = new BigFraction(0);
    public static final BigFraction MINUS_ONE = new BigFraction(-1);
    public static final BigFraction FOUR_FIFTHS = new BigFraction(4, 5);
    public static final BigFraction ONE_FIFTH = new BigFraction(1, 5);
    public static final BigFraction ONE_HALF = new BigFraction(1, 2);
    public static final BigFraction ONE_QUARTER = new BigFraction(1, 4);
    public static final BigFraction ONE_THIRD = new BigFraction(1, 3);
    public static final BigFraction THREE_FIFTHS = new BigFraction(3, 5);
    public static final BigFraction THREE_QUARTERS = new BigFraction(3, 4);
    public static final BigFraction TWO_FIFTHS = new BigFraction(2, 5);
    public static final BigFraction TWO_QUARTERS = new BigFraction(2, 4);
    public static final BigFraction TWO_THIRDS = new BigFraction(2, 3);
    private static final long serialVersionUID = -5630213147331578515L;
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    private final BigInteger numerator;
    private final BigInteger denominator;

    public BigFraction(BigInteger bigInteger) {
        this(bigInteger, BigInteger.ONE);
    }

    public BigFraction(BigInteger bigInteger, BigInteger bigInteger2) {
        MathUtils.checkNotNull(bigInteger, LocalizedFormats.NUMERATOR, new Object[0]);
        MathUtils.checkNotNull(bigInteger2, LocalizedFormats.DENOMINATOR, new Object[0]);
        if (bigInteger2.signum() == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (bigInteger.signum() == 0) {
            this.numerator = BigInteger.ZERO;
            this.denominator = BigInteger.ONE;
        } else {
            BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
            if (BigInteger.ONE.compareTo(bigInteger3) < 0) {
                bigInteger = bigInteger.divide(bigInteger3);
                bigInteger2 = bigInteger2.divide(bigInteger3);
            }
            if (bigInteger2.signum() == -1) {
                bigInteger = bigInteger.negate();
                bigInteger2 = bigInteger2.negate();
            }
            this.numerator = bigInteger;
            this.denominator = bigInteger2;
        }
    }

    public BigFraction(double d) throws MathIllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NAN_VALUE_CONVERSION, new Object[0]);
        }
        if (Double.isInfinite(d)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_VALUE_CONVERSION, new Object[0]);
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MIN_VALUE;
        long l3 = l & 0x7FF0000000000000L;
        long l4 = l & 0xFFFFFFFFFFFFFL;
        if (l3 != 0L) {
            l4 |= 0x10000000000000L;
        }
        if (l2 != 0L) {
            l4 = -l4;
        }
        int n = (int)(l3 >> 52) - 1075;
        while ((l4 & 0x1FFFFFFFFFFFFEL) != 0L && (l4 & 1L) == 0L) {
            l4 >>= 1;
            ++n;
        }
        if (n < 0) {
            this.numerator = BigInteger.valueOf(l4);
            this.denominator = BigInteger.ZERO.flipBit(-n);
        } else {
            this.numerator = BigInteger.valueOf(l4).multiply(BigInteger.ZERO.flipBit(n));
            this.denominator = BigInteger.ONE;
        }
    }

    public BigFraction(double d, double d2, int n) throws FractionConversionException {
        this(d, d2, Integer.MAX_VALUE, n);
    }

    private BigFraction(double d, double d2, int n, int n2) throws FractionConversionException {
        long l = Integer.MAX_VALUE;
        double d3 = d;
        long l2 = (long)FastMath.floor(d3);
        if (FastMath.abs(l2) > l) {
            throw new FractionConversionException(d, l2, 1L);
        }
        if (FastMath.abs((double)l2 - d) < d2) {
            this.numerator = BigInteger.valueOf(l2);
            this.denominator = BigInteger.ONE;
            return;
        }
        long l3 = 1L;
        long l4 = 0L;
        long l5 = l2;
        long l6 = 1L;
        long l7 = 0L;
        long l8 = 1L;
        int n3 = 0;
        boolean bl = false;
        do {
            ++n3;
            double d4 = 1.0 / (d3 - (double)l2);
            long l9 = (long)FastMath.floor(d4);
            l7 = l9 * l5 + l3;
            l8 = l9 * l6 + l4;
            if (l7 > l || l8 > l) {
                if (d2 == 0.0 && FastMath.abs(l6) < (long)n) break;
                throw new FractionConversionException(d, l7, l8);
            }
            double d5 = (double)l7 / (double)l8;
            if (n3 < n2 && FastMath.abs(d5 - d) > d2 && l8 < (long)n) {
                l3 = l5;
                l5 = l7;
                l4 = l6;
                l6 = l8;
                l2 = l9;
                d3 = d4;
                continue;
            }
            bl = true;
        } while (!bl);
        if (n3 >= n2) {
            throw new FractionConversionException(d, n2);
        }
        if (l8 < (long)n) {
            this.numerator = BigInteger.valueOf(l7);
            this.denominator = BigInteger.valueOf(l8);
        } else {
            this.numerator = BigInteger.valueOf(l5);
            this.denominator = BigInteger.valueOf(l6);
        }
    }

    public BigFraction(double d, int n) throws FractionConversionException {
        this(d, 0.0, n, 100);
    }

    public BigFraction(int n) {
        this(BigInteger.valueOf(n), BigInteger.ONE);
    }

    public BigFraction(int n, int n2) {
        this(BigInteger.valueOf(n), BigInteger.valueOf(n2));
    }

    public BigFraction(long l) {
        this(BigInteger.valueOf(l), BigInteger.ONE);
    }

    public BigFraction(long l, long l2) {
        this(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public static BigFraction getReducedFraction(int n, int n2) {
        if (n == 0) {
            return ZERO;
        }
        return new BigFraction(n, n2);
    }

    public BigFraction abs() {
        return this.numerator.signum() == 1 ? this : this.negate();
    }

    @Override
    public BigFraction add(BigInteger bigInteger) throws NullArgumentException {
        MathUtils.checkNotNull(bigInteger);
        if (this.numerator.signum() == 0) {
            return new BigFraction(bigInteger);
        }
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new BigFraction(this.numerator.add(this.denominator.multiply(bigInteger)), this.denominator);
    }

    @Override
    public BigFraction add(int n) {
        return this.add(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction add(long l) {
        return this.add(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction add(BigFraction bigFraction) {
        MathUtils.checkNotNull(bigFraction, LocalizedFormats.FRACTION, new Object[0]);
        if (bigFraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return bigFraction;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (this.denominator.equals(bigFraction.denominator)) {
            bigInteger = this.numerator.add(bigFraction.numerator);
            bigInteger2 = this.denominator;
        } else {
            bigInteger = this.numerator.multiply(bigFraction.denominator).add(bigFraction.numerator.multiply(this.denominator));
            bigInteger2 = this.denominator.multiply(bigFraction.denominator);
        }
        if (bigInteger.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bigInteger, bigInteger2);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal bigDecimalValue(int n) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), n);
    }

    public BigDecimal bigDecimalValue(int n, int n2) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), n, n2);
    }

    @Override
    public int compareTo(BigFraction bigFraction) {
        int n;
        int n2 = this.numerator.signum();
        if (n2 != (n = bigFraction.numerator.signum())) {
            return n2 > n ? 1 : -1;
        }
        if (n2 == 0) {
            return 0;
        }
        BigInteger bigInteger = this.numerator.multiply(bigFraction.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(bigFraction.numerator);
        return bigInteger.compareTo(bigInteger2);
    }

    @Override
    public BigFraction divide(BigInteger bigInteger) {
        MathUtils.checkNotNull(bigInteger);
        if (bigInteger.signum() == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator, this.denominator.multiply(bigInteger));
    }

    @Override
    public BigFraction divide(int n) {
        return this.divide(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction divide(BigFraction bigFraction) {
        MathUtils.checkNotNull(bigFraction, LocalizedFormats.FRACTION, new Object[0]);
        if (bigFraction.numerator.signum() == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(bigFraction.reciprocal());
    }

    @Override
    public double doubleValue() {
        double d = this.numerator.doubleValue() / this.denominator.doubleValue();
        if (Double.isNaN(d)) {
            int n = FastMath.max(this.numerator.bitLength(), this.denominator.bitLength()) - FastMath.getExponent(Double.MAX_VALUE);
            d = this.numerator.shiftRight(n).doubleValue() / this.denominator.shiftRight(n).doubleValue();
        }
        return d;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof BigFraction) {
            BigFraction bigFraction = ((BigFraction)object).reduce();
            BigFraction bigFraction2 = this.reduce();
            bl = bigFraction2.numerator.equals(bigFraction.numerator) && bigFraction2.denominator.equals(bigFraction.denominator);
        }
        return bl;
    }

    @Override
    public float floatValue() {
        float f = this.numerator.floatValue() / this.denominator.floatValue();
        if (Double.isNaN(f)) {
            int n = FastMath.max(this.numerator.bitLength(), this.denominator.bitLength()) - FastMath.getExponent(Float.MAX_VALUE);
            f = this.numerator.shiftRight(n).floatValue() / this.denominator.shiftRight(n).floatValue();
        }
        return f;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public int getDenominatorAsInt() {
        return this.denominator.intValue();
    }

    public long getDenominatorAsLong() {
        return this.denominator.longValue();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public int getNumeratorAsInt() {
        return this.numerator.intValue();
    }

    public long getNumeratorAsLong() {
        return this.numerator.longValue();
    }

    public int hashCode() {
        return 37 * (629 + this.numerator.hashCode()) + this.denominator.hashCode();
    }

    @Override
    public int intValue() {
        return this.numerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    @Override
    public BigFraction multiply(BigInteger bigInteger) {
        MathUtils.checkNotNull(bigInteger);
        if (this.numerator.signum() == 0 || bigInteger.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bigInteger.multiply(this.numerator), this.denominator);
    }

    @Override
    public BigFraction multiply(int n) {
        if (n == 0 || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction multiply(long l) {
        if (l == 0L || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction multiply(BigFraction bigFraction) {
        MathUtils.checkNotNull(bigFraction, LocalizedFormats.FRACTION, new Object[0]);
        if (this.numerator.signum() == 0 || bigFraction.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator.multiply(bigFraction.numerator), this.denominator.multiply(bigFraction.denominator));
    }

    @Override
    public BigFraction negate() {
        return new BigFraction(this.numerator.negate(), this.denominator);
    }

    public double percentageValue() {
        return this.multiply(ONE_HUNDRED).doubleValue();
    }

    public BigFraction pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (n < 0) {
            return new BigFraction(this.denominator.pow(-n), this.numerator.pow(-n));
        }
        return new BigFraction(this.numerator.pow(n), this.denominator.pow(n));
    }

    public BigFraction pow(long l) {
        if (l == 0L) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (l < 0L) {
            return new BigFraction(ArithmeticUtils.pow(this.denominator, -l), ArithmeticUtils.pow(this.numerator, -l));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, l), ArithmeticUtils.pow(this.denominator, l));
    }

    public BigFraction pow(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (bigInteger.signum() == -1) {
            BigInteger bigInteger2 = bigInteger.negate();
            return new BigFraction(ArithmeticUtils.pow(this.denominator, bigInteger2), ArithmeticUtils.pow(this.numerator, bigInteger2));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, bigInteger), ArithmeticUtils.pow(this.denominator, bigInteger));
    }

    public double pow(double d) {
        return FastMath.pow(this.numerator.doubleValue(), d) / FastMath.pow(this.denominator.doubleValue(), d);
    }

    @Override
    public BigFraction reciprocal() {
        return new BigFraction(this.denominator, this.numerator);
    }

    public BigFraction reduce() {
        BigInteger bigInteger = this.numerator.gcd(this.denominator);
        if (BigInteger.ONE.compareTo(bigInteger) < 0) {
            return new BigFraction(this.numerator.divide(bigInteger), this.denominator.divide(bigInteger));
        }
        return this;
    }

    @Override
    public BigFraction subtract(BigInteger bigInteger) {
        MathUtils.checkNotNull(bigInteger);
        if (bigInteger.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return new BigFraction(bigInteger.negate());
        }
        return new BigFraction(this.numerator.subtract(this.denominator.multiply(bigInteger)), this.denominator);
    }

    @Override
    public BigFraction subtract(int n) {
        return this.subtract(BigInteger.valueOf(n));
    }

    @Override
    public BigFraction subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction subtract(BigFraction bigFraction) {
        MathUtils.checkNotNull(bigFraction, LocalizedFormats.FRACTION, new Object[0]);
        if (bigFraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return bigFraction.negate();
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (this.denominator.equals(bigFraction.denominator)) {
            bigInteger = this.numerator.subtract(bigFraction.numerator);
            bigInteger2 = this.denominator;
        } else {
            bigInteger = this.numerator.multiply(bigFraction.denominator).subtract(bigFraction.numerator.multiply(this.denominator));
            bigInteger2 = this.denominator.multiply(bigFraction.denominator);
        }
        return new BigFraction(bigInteger, bigInteger2);
    }

    public String toString() {
        Object object = null;
        object = BigInteger.ONE.equals(this.denominator) ? this.numerator.toString() : (BigInteger.ZERO.equals(this.numerator) ? "0" : this.numerator + " / " + this.denominator);
        return object;
    }

    public BigFractionField getField() {
        return BigFractionField.getInstance();
    }
}

