/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.math4.Field;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.core.Precision;

public class MathArrays {
    private MathArrays() {
    }

    public static double[] scale(double d, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public static void scaleInPlace(double d, double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }

    public static double[] ebeAdd(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray3[n] = dArray3[n] + dArray2[i];
        }
        return dArray3;
    }

    public static double[] ebeSubtract(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray3[n] = dArray3[n] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] ebeMultiply(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray3[n] = dArray3[n] * dArray2[i];
        }
        return dArray3;
    }

    public static double[] ebeDivide(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray3[n] = dArray3[n] / dArray2[i];
        }
        return dArray3;
    }

    public static double distance1(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += FastMath.abs(dArray[i] - dArray2[i]);
        }
        return d;
    }

    public static int distance1(int[] nArray, int[] nArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(nArray, nArray2);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += FastMath.abs(nArray[i] - nArray2[i]);
        }
        return n;
    }

    public static double distance(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return FastMath.sqrt(d);
    }

    public static double distance(int[] nArray, int[] nArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(nArray, nArray2);
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = nArray[i] - nArray2[i];
            d += d2 * d2;
        }
        return FastMath.sqrt(d);
    }

    public static double distanceInf(double[] dArray, double[] dArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d = FastMath.max(d, FastMath.abs(dArray[i] - dArray2[i]));
        }
        return d;
    }

    public static int distanceInf(int[] nArray, int[] nArray2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(nArray, nArray2);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = FastMath.max(n, FastMath.abs(nArray[i] - nArray2[i]));
        }
        return n;
    }

    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] TArray, OrderDirection orderDirection, boolean bl) {
        T t = TArray[0];
        int n = TArray.length;
        for (int i = 1; i < n; ++i) {
            switch (orderDirection) {
                case INCREASING: {
                    int n2 = t.compareTo(TArray[i]);
                    if (!(bl ? n2 >= 0 : n2 > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int n2 = TArray[i].compareTo(t);
                    if (!(bl ? n2 >= 0 : n2 > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            t = TArray[i];
        }
        return true;
    }

    public static boolean isMonotonic(double[] dArray, OrderDirection orderDirection, boolean bl) {
        return MathArrays.checkOrder(dArray, orderDirection, bl, false);
    }

    public static boolean checkEqualLength(double[] dArray, double[] dArray2, boolean bl) {
        if (dArray.length == dArray2.length) {
            return true;
        }
        if (bl) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        return false;
    }

    public static void checkEqualLength(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2, true);
    }

    public static boolean checkEqualLength(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray.length == nArray2.length) {
            return true;
        }
        if (bl) {
            throw new DimensionMismatchException(nArray.length, nArray2.length);
        }
        return false;
    }

    public static void checkEqualLength(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2, true);
    }

    public static boolean checkOrder(double[] dArray, OrderDirection orderDirection, boolean bl, boolean bl2) throws NonMonotonicSequenceException {
        int n;
        double d = dArray[0];
        int n2 = dArray.length;
        block4: for (n = 1; n < n2; ++n) {
            switch (orderDirection) {
                case INCREASING: {
                    if (!(bl ? dArray[n] <= d : dArray[n] < d)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(bl ? dArray[n] >= d : dArray[n] > d)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            d = dArray[n];
        }
        if (n == n2) {
            return true;
        }
        if (bl2) {
            throw new NonMonotonicSequenceException(dArray[n], (Number)d, n, orderDirection, bl);
        }
        return false;
    }

    public static void checkOrder(double[] dArray, OrderDirection orderDirection, boolean bl) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(dArray, orderDirection, bl, true);
    }

    public static void checkOrder(double[] dArray) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(dArray, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] lArray) throws NullArgumentException, DimensionMismatchException {
        MathUtils.checkNotNull(lArray);
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i].length == lArray[0].length) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, lArray[i].length, lArray[0].length);
        }
    }

    public static void checkPositive(double[] dArray) throws NotStrictlyPositiveException {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] <= 0.0)) continue;
            throw new NotStrictlyPositiveException(dArray[i]);
        }
    }

    public static void checkNotNaN(double[] dArray) throws NotANumberException {
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            throw new NotANumberException();
        }
    }

    public static void checkNonNegative(long[] lArray) throws NotPositiveException {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 0L) continue;
            throw new NotPositiveException(lArray[i]);
        }
    }

    public static void checkNonNegative(long[][] lArray) throws NotPositiveException {
        for (int i = 0; i < lArray.length; ++i) {
            for (int j = 0; j < lArray[i].length; ++j) {
                if (lArray[i][j] >= 0L) continue;
                throw new NotPositiveException(lArray[i][j]);
            }
        }
    }

    public static void sortInPlace(double[] dArray, double[] ... dArray2) throws DimensionMismatchException, NullArgumentException {
        MathArrays.sortInPlace(dArray, OrderDirection.INCREASING, dArray2);
    }

    public static void sortInPlace(double[] dArray, OrderDirection orderDirection, double[] ... dArray2) throws NullArgumentException, DimensionMismatchException {
        Object object;
        int n;
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n2 = dArray2.length;
        int n3 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = dArray2[i];
            if (dArray3 == null) {
                throw new NullArgumentException();
            }
            if (dArray3.length == n3) continue;
            throw new DimensionMismatchException(dArray3.length, n3);
        }
        ArrayList<PairDoubleInteger> arrayList = new ArrayList<PairDoubleInteger>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(new PairDoubleInteger(dArray[i], i));
        }
        Comparator<PairDoubleInteger> comparator = orderDirection == OrderDirection.INCREASING ? new Comparator<PairDoubleInteger>(){

            @Override
            public int compare(PairDoubleInteger pairDoubleInteger, PairDoubleInteger pairDoubleInteger2) {
                return Double.compare(pairDoubleInteger.getKey(), pairDoubleInteger2.getKey());
            }
        } : new Comparator<PairDoubleInteger>(){

            @Override
            public int compare(PairDoubleInteger pairDoubleInteger, PairDoubleInteger pairDoubleInteger2) {
                return Double.compare(pairDoubleInteger2.getKey(), pairDoubleInteger.getKey());
            }
        };
        Collections.sort(arrayList, comparator);
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            object = (PairDoubleInteger)arrayList.get(n);
            dArray[n] = ((PairDoubleInteger)object).getKey();
            nArray[n] = ((PairDoubleInteger)object).getValue();
        }
        for (n = 0; n < n2; ++n) {
            object = dArray2[n];
            double[] dArray4 = (double[])object.clone();
            for (int i = 0; i < n3; ++i) {
                object[i] = dArray4[nArray[i]];
            }
        }
    }

    public static int[] copyOf(int[] nArray) {
        return MathArrays.copyOf(nArray, nArray.length);
    }

    public static double[] copyOf(double[] dArray) {
        return MathArrays.copyOf(dArray, dArray.length);
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, FastMath.min(n, nArray.length));
        return nArray2;
    }

    public static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, FastMath.min(n, dArray.length));
        return dArray2;
    }

    public static double[] copyOfRange(double[] dArray, int n, int n2) {
        int n3 = n2 - n;
        double[] dArray2 = new double[n3];
        System.arraycopy(dArray, n, dArray2, 0, FastMath.min(n3, dArray.length - n));
        return dArray2;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return !(fArray == null ^ fArray2 == null);
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (Precision.equals(fArray[i], fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return !(fArray == null ^ fArray2 == null);
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (Precision.equalsIncludingNaN(fArray[i], fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (Precision.equals(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (Precision.equalsIncludingNaN(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static double[] normalizeArray(double[] dArray, double d) throws MathIllegalArgumentException, MathArithmeticException {
        int n;
        if (Double.isInfinite(d)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(d)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double d2 = 0.0;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            if (Double.isInfinite(dArray[n])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, dArray[n], n);
            }
            if (Double.isNaN(dArray[n])) continue;
            d2 += dArray[n];
        }
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = Double.isNaN(dArray[n]) ? Double.NaN : dArray[n] * d / d2;
        }
        return dArray2;
    }

    public static <T> T[] buildArray(Field<T> field, int n) {
        Object[] objectArray = (Object[])Array.newInstance(field.getRuntimeClass(), n);
        Arrays.fill(objectArray, field.getZero());
        return objectArray;
    }

    public static <T> T[][] buildArray(Field<T> field, int n, int n2) {
        Object[][] objectArray;
        if (n2 < 0) {
            T[] TArray = MathArrays.buildArray(field, 0);
            objectArray = (Object[][])Array.newInstance(TArray.getClass(), n);
        } else {
            objectArray = (Object[][])Array.newInstance(field.getRuntimeClass(), n, n2);
            for (int i = 0; i < n; ++i) {
                Arrays.fill(objectArray[i], field.getZero());
            }
        }
        return objectArray;
    }

    public static double[] convolve(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(dArray);
        MathUtils.checkNotNull(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n == 0 || n2 == 0) {
            throw new NoDataException();
        }
        int n3 = n + n2 - 1;
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            double d = 0.0;
            int n4 = FastMath.max(0, i + 1 - n);
            int n5 = i - n4;
            while (n4 < n2 && n5 >= 0) {
                d += dArray[n5--] * dArray2[n4++];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    public static int[] natural(int n) {
        return MathArrays.sequence(n, 0, 1);
    }

    public static int[] sequence(int n, int n2, int n3) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2 + i * n3;
        }
        return nArray;
    }

    public static boolean verifyValues(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return MathArrays.verifyValues(dArray, n, n2, false);
    }

    public static boolean verifyValues(double[] dArray, int n, int n2, boolean bl) throws MathIllegalArgumentException {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        if (n + n2 > dArray.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(n + n2), dArray.length, true);
        }
        return n2 != 0 || bl;
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n, int n2) throws MathIllegalArgumentException {
        return MathArrays.verifyValues(dArray, dArray2, n, n2, false);
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n, int n2, boolean bl) throws MathIllegalArgumentException {
        if (dArray2 == null || dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        MathArrays.checkEqualLength(dArray2, dArray);
        boolean bl2 = false;
        for (int i = n; i < n + n2; ++i) {
            double d = dArray2[i];
            if (Double.isNaN(d)) {
                throw new MathIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i);
            }
            if (Double.isInfinite(d)) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, d, i);
            }
            if (d < 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, d);
            }
            if (bl2 || !(d > 0.0)) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw new MathIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return MathArrays.verifyValues(dArray, n, n2, bl);
    }

    public static double[] concatenate(double[] ... dArray) {
        int n = 0;
        for (double[] dArray2 : dArray) {
            n += dArray2.length;
        }
        int n2 = 0;
        int n3 = 0;
        double[] dArray3 = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            n3 = dArray[i].length;
            System.arraycopy(dArray[i], 0, dArray3, n2, n3);
            n2 += n3;
        }
        return dArray3;
    }

    public static double[] unique(double[] dArray) {
        int n;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (n = 0; n < dArray.length; ++n) {
            treeSet.add(dArray[n]);
        }
        n = treeSet.size();
        double[] dArray2 = new double[n];
        Iterator iterator = treeSet.descendingIterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            dArray2[n2++] = (Double)iterator.next();
        }
        return dArray2;
    }

    private static class PairDoubleInteger {
        private final double key;
        private final int value;

        PairDoubleInteger(double d, int n) {
            this.key = d;
            this.value = n;
        }

        public double getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }
}

