/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.apache.commons.numbers.fraction.BigFraction;
import org.apache.commons.numbers.fraction.BigFractionFormat;

public class ProperBigFractionFormat
extends BigFractionFormat {
    private static final long serialVersionUID = -6337346779577272307L;
    private NumberFormat wholeFormat;

    public ProperBigFractionFormat() {
        this(ProperBigFractionFormat.getDefaultNumberFormat());
    }

    public ProperBigFractionFormat(NumberFormat numberFormat) {
        this(numberFormat, (NumberFormat)numberFormat.clone(), (NumberFormat)numberFormat.clone());
    }

    public ProperBigFractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(numberFormat2, numberFormat3);
        this.setWholeFormat(numberFormat);
    }

    @Override
    public StringBuffer format(BigFraction bigFraction, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        BigInteger bigInteger = bigFraction.getNumerator();
        BigInteger bigInteger2 = bigFraction.getDenominator();
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        bigInteger = bigInteger.remainder(bigInteger2);
        if (!BigInteger.ZERO.equals(bigInteger3)) {
            this.getWholeFormat().format(bigInteger3, stringBuffer, fieldPosition);
            stringBuffer.append(' ');
            if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                bigInteger = bigInteger.negate();
            }
        }
        this.getNumeratorFormat().format(bigInteger, stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(bigInteger2, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public NumberFormat getWholeFormat() {
        return this.wholeFormat;
    }

    @Override
    public BigFraction parse(String string, ParsePosition parsePosition) {
        boolean bl;
        BigFraction bigFraction = super.parse(string, parsePosition);
        if (bigFraction != null) {
            return bigFraction;
        }
        int n = parsePosition.getIndex();
        ProperBigFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        BigInteger bigInteger = this.parseNextBigInteger(string, parsePosition);
        if (bigInteger == null) {
            parsePosition.setIndex(n);
            return null;
        }
        ProperBigFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        BigInteger bigInteger2 = this.parseNextBigInteger(string, parsePosition);
        if (bigInteger2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c = ProperBigFractionFormat.parseNextCharacter(string, parsePosition);
        switch (c) {
            case '\u0000': {
                return new BigFraction(bigInteger2);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        ProperBigFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        BigInteger bigInteger3 = this.parseNextBigInteger(string, parsePosition);
        if (bigInteger3 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (bigInteger3.compareTo(BigInteger.ZERO) < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        boolean bl2 = bl = bigInteger.compareTo(BigInteger.ZERO) < 0;
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        bigInteger2 = bigInteger.multiply(bigInteger3).add(bigInteger2);
        if (bl) {
            bigInteger2 = bigInteger2.negate();
        }
        return new BigFraction(bigInteger2, bigInteger3);
    }

    public void setWholeFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("whole format");
        }
        this.wholeFormat = numberFormat;
    }
}

