/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class KISSRandom
extends IntProvider {
    private static final int SEED_SIZE = 4;
    private int z;
    private int w;
    private int jsr;
    private int jcong;

    public KISSRandom(int[] nArray) {
        this.setSeedInternal(nArray);
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new int[]{this.z, this.w, this.jsr, this.jcong}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 16);
        int[] nArray = NumberFactory.makeIntArray(byArray2[0]);
        this.z = nArray[0];
        this.w = nArray[1];
        this.jsr = nArray[2];
        this.jcong = nArray[3];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(int[] nArray) {
        int[] nArray2 = new int[4];
        this.fillState(nArray2, nArray);
        this.z = nArray2[0];
        this.w = nArray2[1];
        this.jsr = nArray2[2];
        this.jcong = nArray2[3];
    }

    @Override
    public int next() {
        this.z = this.computeNew(36969, this.z);
        this.w = this.computeNew(18000, this.w);
        int n = (this.z << 16) + this.w;
        this.jsr ^= this.jsr << 13;
        this.jsr ^= this.jsr >>> 17;
        this.jsr ^= this.jsr << 5;
        this.jcong = 69069 * this.jcong + 1234567;
        return (n ^ this.jcong) + this.jsr;
    }

    private int computeNew(int n, int n2) {
        return n * (n2 & 0xFFFF) + (n2 >>> 16);
    }
}

