/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;

public class SmallMeanPoissonSampler
implements DiscreteSampler {
    private final double p0;
    private final int limit;
    private final UniformRandomProvider rng;

    public SmallMeanPoissonSampler(UniformRandomProvider uniformRandomProvider, double d) {
        this.rng = uniformRandomProvider;
        if (d <= 0.0) {
            throw new IllegalArgumentException("mean is not strictly positive: " + d);
        }
        this.p0 = Math.exp(-d);
        if (!(this.p0 > 0.0)) {
            throw new IllegalArgumentException("No p(x=0) probability for mean: " + d);
        }
        this.limit = (int)Math.ceil(1000.0 * d);
    }

    @Override
    public int sample() {
        int n;
        double d = 1.0;
        for (n = 0; n < this.limit && (d *= this.rng.nextDouble()) >= this.p0; ++n) {
        }
        return n;
    }

    public String toString() {
        return "Small Mean Poisson deviate [" + this.rng.toString() + "]";
    }
}

