/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;
import org.apache.commons.rng.simple.RandomSource;

public final class JDKRandomBridge
extends Random {
    private static final long serialVersionUID = 20161107L;
    private final RandomSource source;
    private transient RestorableUniformRandomProvider delegate;
    private final transient boolean isInitialized;

    public JDKRandomBridge(RandomSource randomSource, Object object) {
        this.source = randomSource;
        this.delegate = RandomSource.create(randomSource, object, new Object[0]);
        this.isInitialized = true;
    }

    @Override
    public synchronized void setSeed(long l) {
        if (this.isInitialized) {
            this.delegate = RandomSource.create(this.source, l, new Object[0]);
            super.setSeed(0L);
        }
    }

    @Override
    protected synchronized int next(int n) {
        return this.delegate.nextInt() >>> 32 - n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(((RandomProviderDefaultState)this.delegate.saveState()).getState());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.delegate = RandomSource.create(this.source);
        this.delegate.restoreState(new RandomProviderDefaultState((byte[])objectInputStream.readObject()));
    }
}

