/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.ast;

import io.virtdata.ast.ArgType;
import io.virtdata.ast.BooleanArg;
import io.virtdata.ast.DoubleArg;
import io.virtdata.ast.FloatArg;
import io.virtdata.ast.IntegerArg;
import io.virtdata.ast.LongArg;
import io.virtdata.ast.RefArg;
import io.virtdata.ast.StringArg;
import io.virtdata.ast.VariableRef;
import java.util.ArrayList;
import java.util.List;

public class FunctionCall
implements ArgType {
    private String funcName;
    private List<ArgType> args = new ArrayList<ArgType>();
    private String inputType;
    private String outputType;
    private String inputClass;

    public FunctionCall() {
    }

    public FunctionCall(String string) {
        this.funcName = string;
    }

    public FunctionCall(String string, String string2) {
        this.inputType = string;
        this.funcName = string2;
    }

    public void addFunctionArg(ArgType argType) {
        this.args.add(argType);
    }

    public void setInputType(String string) {
        this.inputType = string;
    }

    public void setFuncName(String string) {
        this.funcName = string;
    }

    public void setOutputType(String string) {
        this.outputType = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)(this.inputType == null ? "" : this.inputType + "->"));
        stringBuilder.append(this.funcName);
        stringBuilder.append("(");
        String string = "";
        for (ArgType argType : this.args) {
            stringBuilder.append(string);
            stringBuilder.append(argType);
            string = ",";
        }
        stringBuilder.append(")");
        stringBuilder.append((String)(this.outputType == null ? "" : "->" + this.outputType));
        return stringBuilder.toString();
    }

    public FunctionCall getVirtdataCall(int n) {
        return (FunctionCall)this.args.get(n);
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public List<ArgType> getArgs() {
        return this.args;
    }

    public Object[] getArguments() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block10: for (ArgType argType : this.getArgs()) {
            ArgType.TypeName typeName = ArgType.TypeName.valueOf(argType);
            switch (typeName) {
                case RefArg: {
                    arrayList.add(new VariableRef(((RefArg)argType).getRefName()));
                    continue block10;
                }
                case FunctionCall: {
                    arrayList.add(argType);
                    continue block10;
                }
                case StringArg: {
                    arrayList.add(((StringArg)argType).getStringValue());
                    continue block10;
                }
                case FloatArg: {
                    arrayList.add(((FloatArg)argType).getFloatValue());
                    continue block10;
                }
                case IntegerArg: {
                    arrayList.add(((IntegerArg)argType).getIntValue());
                    continue block10;
                }
                case LongArg: {
                    arrayList.add(((LongArg)argType).getLongValue());
                    continue block10;
                }
                case DoubleArg: {
                    arrayList.add(((DoubleArg)argType).getDoubleValue());
                    continue block10;
                }
                case BooleanArg: {
                    arrayList.add(((BooleanArg)argType).getBooleanValue());
                    continue block10;
                }
            }
            throw new RuntimeException("Could not map type into argument object: " + typeName);
        }
        return arrayList.toArray();
    }
}

